/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.debug.DebugProperties;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class DynamicTextureImage
implements ImageRenderer {
    protected static final class_1060 textureManager = class_310.method_1551().method_1531();
    protected class_1011 image;
    protected class_1043 texture;
    protected final class_2960 uniqueLocation;
    protected final int width;
    protected final int height;

    public DynamicTextureImage(class_1011 image, class_2960 location) {
        RenderSystem.assertOnRenderThread();
        this.image = image;
        this.texture = new class_1043(image);
        this.uniqueLocation = location;
        textureManager.method_4616(this.uniqueLocation, (class_1044)this.texture);
        this.width = image.method_4307();
        this.height = image.method_4323();
    }

    @Override
    public int render(class_332 graphics, int x, int y, int renderWidth, float tickDelta) {
        if (this.image == null) {
            return 0;
        }
        float ratio = (float)renderWidth / (float)this.width;
        int targetHeight = (int)((float)this.height * ratio);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        graphics.method_51448().method_22905(ratio, ratio, 1.0f);
        if (DebugProperties.IMAGE_FILTERING) {
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
        }
        GuiUtils.blitGuiTex(graphics, this.uniqueLocation, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        graphics.method_51448().method_22909();
        return targetHeight;
    }

    @Override
    public void close() {
        this.image.close();
        this.image = null;
        this.texture = null;
        textureManager.method_4615(this.uniqueLocation);
    }

    public static ImageRendererFactory fromPath(Path imagePath, class_2960 location) {
        return () -> () -> new DynamicTextureImage(class_1011.method_4309((InputStream)new FileInputStream(imagePath.toFile())), location);
    }
}

