/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config;

import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.metadata.WidgetSize;
import org.quiltmc.config.api.ReflectiveConfig;
import org.quiltmc.config.api.annotations.Alias;
import org.quiltmc.config.api.annotations.Comment;
import org.quiltmc.config.api.annotations.FloatRange;
import org.quiltmc.config.api.annotations.IntegerRange;
import org.quiltmc.config.api.annotations.SerializedNameConvention;
import org.quiltmc.config.api.metadata.NamingSchemes;
import org.quiltmc.config.api.values.TrackedValue;

@SerializedNameConvention(value=NamingSchemes.SNAKE_CASE)
public class OkZoomerConfig
extends ReflectiveConfig {
    @Comment(value={"Allows for configuring the main zoom features."})
    public final FeaturesConfig features = new FeaturesConfig();
    @Alias(value={"values"})
    @Comment(value={"Allows for precise tweaking of the zoom."})
    public final ZoomValuesConfig zoomValues = new ZoomValuesConfig();
    @Alias(value={"values"})
    @Comment(value={"Allows for precise tweaking of zoom transitions."})
    public final TransitionValuesConfig transitionValues = new TransitionValuesConfig();
    @Comment(value={"Provides a selection of unusual options."})
    public final TweaksConfig tweaks = new TweaksConfig();

    public static class FeaturesConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"OFF\": Disables the zoom's cinematic camera.\n\"VANILLA\": Uses the game's cinematic camera while zooming.\n\"MULTIPLIED\": Uses the cinematic camera with a configurable multiplier while zooming.\n"})
        public final TrackedValue<ConfigEnums.CinematicCameraOptions> cinematicCamera = this.value(ConfigEnums.CinematicCameraOptions.OFF);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Divides the mouse sensitivity with the zoom divisor while zooming."})
        public final TrackedValue<Boolean> reduceSensitivity = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"OFF\": The zoom will abruptly transition between its on and off states.\n\"SMOOTH\": The zoom will smoothly transition between its on and off states in a manner resembling the game's FOV transitions.\n\"LINEAR\": The zoom will linearly transition between its on and off states.\n"})
        public final TrackedValue<ConfigEnums.ZoomTransitionOptions> zoomTransition = this.value(ConfigEnums.ZoomTransitionOptions.SMOOTH);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"HOLD\": The zoom will require the zoom key to be held.\n\"TOGGLE\": The zoom will be toggled by the zoom key.\n\"PERSISTENT\": The zoom will always be enabled, with the zoom key being used for zoom scrolling.\n"})
        public final TrackedValue<ConfigEnums.ZoomModes> zoomMode = this.value(ConfigEnums.ZoomModes.HOLD);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Allows to increase or decrease the zoom by scrolling with the mouse wheel."})
        public final TrackedValue<Boolean> zoomScrolling = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Adds zoom manipulation keys along with the zoom key. A game reboot will be required in order to apply the changes."})
        public final TrackedValue<Boolean> extraKeyBinds = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"\"OFF\": Disables the zoom overlay.\n\"VIGNETTE\": Uses a vignette as the zoom overlay. The vignette texture can be found at assets/ok_zoomer/textures/misc/zoom_overlay.png\n\"SPYGLASS\": Uses the spyglass overlay with the vignette texture.\n"})
        public final TrackedValue<ConfigEnums.ZoomOverlays> zoomOverlay = this.value(ConfigEnums.ZoomOverlays.OFF);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Alias(value={"spyglass_dependency"})
        @Comment(value={"\"OFF\": Zooming won't require a spyglass and won't replace its zoom.\n\"REQUIRE_ITEM\": Zooming will require a spyglass in order to work. This option is configurable through the ok_zoomer:zoom_dependencies item tag.\n\"REPLACE_ZOOM\": Zooming will replace the spyglass zoom but it won't require one in order to work.\n\"BOTH\": Zooming will act as a complete replacement of the spyglass zoom, requiring one to work and replacing its zoom as well.\n"})
        public final TrackedValue<ConfigEnums.SpyglassMode> spyglassMode = this.value(ConfigEnums.SpyglassMode.OFF);
    }

    public static class ZoomValuesConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The divisor applied to the FOV's zoom multiplier. A higher value means more zoom."})
        @FloatRange(min=2.2250738585072014E-308, max=1.7976931348623157E308)
        public final TrackedValue<Double> zoomDivisor = this.value(4.0);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The minimum zoom divisor that you can scroll down."})
        @FloatRange(min=2.2250738585072014E-308, max=1.7976931348623157E308)
        public final TrackedValue<Double> minimumZoomDivisor = this.value(1.0);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The maximum zoom divisor that you can scroll up."})
        @FloatRange(min=2.2250738585072014E-308, max=1.7976931348623157E308)
        public final TrackedValue<Double> maximumZoomDivisor = this.value(50.0);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The number of steps between the zoom divisor and the minimum zoom divisor. Used by zoom scrolling."})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        public final TrackedValue<Integer> lowerScrollSteps = this.value(5);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The number of steps between the zoom divisor and the maximum zoom divisor. Used by zoom scrolling."})
        @IntegerRange(min=0L, max=0x7FFFFFFFL)
        public final TrackedValue<Integer> upperScrollSteps = this.value(10);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The multiplier used for the multiplied cinematic camera."})
        @FloatRange(min=2.2250738585072014E-308, max=32.0)
        public final TrackedValue<Double> cinematicMultiplier = this.value(4.0);
    }

    public static class TransitionValuesConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The factor used for smooth zoom transitions. A lower value means a smoother transition, a higher value means a faster one."})
        @Alias(value={"smooth_multiplier"})
        @FloatRange(min=2.2250738585072014E-308, max=1.0)
        public final TrackedValue<Double> smoothTransitionFactor = this.value(0.6);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The minimum value which the linear zoom transition step can reach."})
        @FloatRange(min=0.0, max=1.7976931348623157E308)
        public final TrackedValue<Double> minimumLinearStep = this.value(0.16);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"The maximum value which the linear zoom transition step can reach."})
        @FloatRange(min=0.0, max=1.7976931348623157E308)
        public final TrackedValue<Double> maximumLinearStep = this.value(0.22);
    }

    public static class TweaksConfig
    extends ReflectiveConfig.Section {
        @WidgetSize(value=WidgetSize.Size.FULL)
        @Comment(value={"If pressed, the \"Save Toolbar Activator\" keybind will be unbound if there's a conflict with the zoom key."})
        public final TrackedValue<Boolean> unbindConflictingKey = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Allows for resetting the zoom with the middle mouse button."})
        public final TrackedValue<Boolean> resetZoomWithMouse = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"If enabled, the current zoom divisor is forgotten once zooming is finished."})
        public final TrackedValue<Boolean> forgetZoomDivisor = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"If enabled, the zoom will use spyglass sounds on zooming in and out."})
        public final TrackedValue<Boolean> useSpyglassSounds = this.value(false);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Shows toasts when the server imposes a restriction."})
        public final TrackedValue<Boolean> showRestrictionToasts = this.value(true);
        @WidgetSize(value=WidgetSize.Size.HALF)
        @Comment(value={"Prints a random owo in the console when the game starts."})
        public final TrackedValue<Boolean> printOwoOnStart = this.value(false);
    }
}

