/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config;

import io.github.ennuil.libzoomer.api.MouseModifier;
import io.github.ennuil.libzoomer.api.TransitionMode;
import io.github.ennuil.libzoomer.api.ZoomOverlay;
import io.github.ennuil.libzoomer.api.modifiers.CinematicCameraMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ContainingMouseModifier;
import io.github.ennuil.libzoomer.api.modifiers.ZoomDivisorMouseModifier;
import io.github.ennuil.libzoomer.api.overlays.SpyglassZoomOverlay;
import io.github.ennuil.libzoomer.api.transitions.InstantTransitionMode;
import io.github.ennuil.libzoomer.api.transitions.SmoothTransitionMode;
import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfig;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import io.github.ennuil.ok_zoomer.wrench_wrapper.WrenchWrapper;
import io.github.ennuil.ok_zoomer.zoom.LinearTransitionMode;
import io.github.ennuil.ok_zoomer.zoom.MultipliedCinematicCameraMouseModifier;
import io.github.ennuil.ok_zoomer.zoom.ZoomerZoomOverlay;
import net.minecraft.class_2960;

public class OkZoomerConfigManager {
    public static final OkZoomerConfig CONFIG = WrenchWrapper.create("ok_zoomer", "config", OkZoomerConfig.class);

    public static void init() {
        OkZoomerConfigManager.configureZoomInstance();
        CONFIG.registerCallback(config -> OkZoomerConfigManager.configureZoomInstance());
    }

    public static void configureZoomInstance() {
        ZoomUtils.ZOOMER_ZOOM.setTransitionMode((TransitionMode)(switch ((ConfigEnums.ZoomTransitionOptions)OkZoomerConfigManager.CONFIG.features.zoomTransition.value()) {
            case ConfigEnums.ZoomTransitionOptions.SMOOTH -> new SmoothTransitionMode(((Double)OkZoomerConfigManager.CONFIG.transitionValues.smoothTransitionFactor.value()).floatValue());
            case ConfigEnums.ZoomTransitionOptions.LINEAR -> new LinearTransitionMode((Double)OkZoomerConfigManager.CONFIG.transitionValues.minimumLinearStep.value(), (Double)OkZoomerConfigManager.CONFIG.transitionValues.maximumLinearStep.value());
            default -> new InstantTransitionMode();
        }));
        ZoomUtils.ZOOMER_ZOOM.setDefaultZoomDivisor(((Double)OkZoomerConfigManager.CONFIG.zoomValues.zoomDivisor.value()).doubleValue());
        OkZoomerConfigManager.configureZoomModifier();
        class_2960 overlayTextureId = OkZoomerConfigManager.CONFIG.features.zoomOverlay.value() == ConfigEnums.ZoomOverlays.SPYGLASS ? class_2960.method_60656((String)"textures/misc/spyglass_scope.png") : ModUtils.id("textures/misc/zoom_overlay.png");
        ZoomUtils.ZOOMER_ZOOM.setZoomOverlay((ZoomOverlay)(switch ((ConfigEnums.ZoomOverlays)OkZoomerConfigManager.CONFIG.features.zoomOverlay.value()) {
            case ConfigEnums.ZoomOverlays.VIGNETTE -> new ZoomerZoomOverlay(overlayTextureId);
            case ConfigEnums.ZoomOverlays.SPYGLASS -> new SpyglassZoomOverlay(overlayTextureId);
            default -> null;
        }));
    }

    public static void configureZoomModifier() {
        ConfigEnums.CinematicCameraOptions cinematicCamera = (ConfigEnums.CinematicCameraOptions)OkZoomerConfigManager.CONFIG.features.cinematicCamera.value();
        boolean reduceSensitivity = (Boolean)OkZoomerConfigManager.CONFIG.features.reduceSensitivity.value();
        if (cinematicCamera != ConfigEnums.CinematicCameraOptions.OFF) {
            Object cinematicModifier = switch (cinematicCamera) {
                case ConfigEnums.CinematicCameraOptions.VANILLA -> new CinematicCameraMouseModifier();
                case ConfigEnums.CinematicCameraOptions.MULTIPLIED -> new MultipliedCinematicCameraMouseModifier((Double)OkZoomerConfigManager.CONFIG.zoomValues.cinematicMultiplier.value());
                default -> null;
            };
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier((MouseModifier)(reduceSensitivity ? new ContainingMouseModifier(new MouseModifier[]{cinematicModifier, new ZoomDivisorMouseModifier()}) : cinematicModifier));
        } else {
            ZoomUtils.ZOOMER_ZOOM.setMouseModifier((MouseModifier)(reduceSensitivity ? new ZoomDivisorMouseModifier() : null));
        }
    }
}

