/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.config.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8027;
import net.minecraft.class_8028;
import net.minecraft.class_8132;
import net.minecraft.class_9017;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.loader.api.minecraft.ClientOnly;

@ClientOnly
public class OkZoomerAbstractSelectionList
extends class_9017 {
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656((String)"widget/scroller");
    private static final class_2960 SCROLLER_BACKGROUND_SPRITE = class_2960.method_60656((String)"widget/scroller_background");
    private static final class_2960 MENU_LIST_BACKGROUND = class_2960.method_60656((String)"textures/gui/menu_list_background.png");
    private static final class_2960 INWORLD_MENU_LIST_BACKGROUND = class_2960.method_60656((String)"textures/gui/inworld_menu_list_background.png");
    private final class_310 minecraft;
    private final List<Entry> children;
    private IntList entryHeights;
    private int contentHeight;
    private int scrollAmount;
    private boolean scrolling;
    @Nullable
    private Entry hovered;

    public OkZoomerAbstractSelectionList(class_310 minecraft, int width, int height, int y) {
        super(0, y, width, height, class_5244.field_39003);
        this.minecraft = minecraft;
        this.children = new ArrayList<Entry>();
        this.entryHeights = new IntArrayList();
        this.contentHeight = height;
        this.scrollAmount = 0;
        this.scrolling = false;
        this.hovered = null;
        this.update();
    }

    @Nullable
    public Entry getFocused() {
        return (Entry)super.method_25399();
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.hovered = this.method_25405(mouseX, mouseY) ? this.getEntryAtPosition(mouseX, mouseY) : null;
        this.renderListBackground(graphics);
        graphics.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
        int i = this.method_46427() - this.scrollAmount;
        for (Entry child : this.children) {
            int oldI = i;
            if ((i += child.getEntryHeight()) < this.method_46427() || oldI > this.field_22759 + this.method_46427()) continue;
            int xToRender = this.method_46426() + this.field_22758 / 2 - this.getRowWidth() / 2;
            child.render(graphics, xToRender, oldI, this.getRowWidth(), mouseX, mouseY, delta);
        }
        graphics.method_44380();
        this.renderListSeparators(graphics);
        if (this.contentHeight - this.field_22759 > 0) {
            this.renderScrollBar(graphics);
        }
    }

    public void method_47399(class_6382 narrationElementOutput) {
        Entry hovered = this.getHovered();
        if (hovered != null) {
            hovered.updateNarration(narrationElementOutput.method_37031());
            this.narrateListElementPosition(narrationElementOutput, hovered);
        } else {
            Entry entry = this.getFocused();
            if (entry != null) {
                entry.updateNarration(narrationElementOutput.method_37031());
                this.narrateListElementPosition(narrationElementOutput, entry);
            }
        }
        narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(class_6382 narrationElementOutput, Entry entry) {
        int i;
        List<Entry> list = this.method_25396();
        if (!list.isEmpty() && (i = list.indexOf(entry)) != -1) {
            narrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.list", (Object[])new Object[]{i + 1, list.size()}));
        }
    }

    @NotNull
    public List<Entry> method_25396() {
        return this.children;
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        if (this.method_25370()) {
            return class_6379.class_6380.field_33786;
        }
        return this.hovered != null ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    private void renderListBackground(class_332 graphics) {
        RenderSystem.enableBlend();
        class_2960 backgroundLocation = this.minecraft.field_1687 == null ? MENU_LIST_BACKGROUND : INWORLD_MENU_LIST_BACKGROUND;
        graphics.method_25290(backgroundLocation, this.method_46426(), this.method_46427(), (float)this.method_55442(), (float)(this.method_55443() + this.getScrollAmount()), this.field_22758, this.field_22759, 32, 32);
        RenderSystem.disableBlend();
    }

    private void renderListSeparators(class_332 graphics) {
        RenderSystem.enableBlend();
        class_2960 headerSeparatorLocation = this.minecraft.field_1687 == null ? class_437.field_49895 : class_437.field_49897;
        class_2960 footerSeparatorLocation = this.minecraft.field_1687 == null ? class_437.field_49896 : class_437.field_49898;
        graphics.method_25290(headerSeparatorLocation, this.method_46426(), this.method_46427() - 2, 0.0f, 0.0f, this.field_22758, 2, 32, 2);
        graphics.method_25290(footerSeparatorLocation, this.method_46426(), this.method_55443(), 0.0f, 0.0f, this.field_22758, 2, 32, 2);
        RenderSystem.disableBlend();
    }

    private void renderScrollBar(class_332 graphics) {
        int size = Math.min(this.field_22759, this.field_22759 * this.field_22759 / this.contentHeight);
        int x = this.getScrollBarPosX();
        double scale = (double)this.scrollAmount / (double)(this.contentHeight - this.field_22759);
        int y = this.method_46427() + (int)(scale * (double)(this.field_22759 - size));
        RenderSystem.enableBlend();
        graphics.method_52706(SCROLLER_BACKGROUND_SPRITE, x, this.method_46427(), 6, this.field_22759);
        graphics.method_52706(SCROLLER_SPRITE, x, y, 6, size);
        RenderSystem.disableBlend();
    }

    protected int getScrollBarPosX() {
        return this.field_22758 / 2 + 156;
    }

    public void update() {
        this.entryHeights = new IntArrayList();
        int contentHeight = 0;
        for (Entry child : this.children) {
            this.entryHeights.add(child.getEntryHeight());
            contentHeight += child.getEntryHeight();
        }
        this.contentHeight = Math.max(this.field_22759, contentHeight);
    }

    public void finish() {
        this.update();
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = class_3532.method_15340((int)scrollAmount, (int)0, (int)Math.max(0, this.contentHeight - this.field_22759));
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.method_46426() && mouseX <= (double)this.method_55442() && mouseY >= (double)this.method_46427() && mouseY <= (double)this.method_55443();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int pos;
        if (!this.scrolling && mouseX > (double)(pos = (this.field_22758 - this.method_46426()) / 2 + 156) && mouseX < (double)(pos + 6)) {
            this.scrolling = true;
            return true;
        }
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        Entry entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null && entry.method_25402(mouseX, mouseY, button)) {
            Entry subEntry = this.getFocused();
            if (subEntry != entry && subEntry != null) {
                subEntry.method_25395(null);
            }
            this.method_25395((class_364)entry);
            this.method_25398(true);
            return true;
        }
        return this.scrolling;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setScrollAmount((int)((double)this.scrollAmount - scrollY * 10.0));
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.method_46427()) {
                this.setScrollAmount(0);
            } else if (mouseY > (double)(this.method_46427() + this.field_22759)) {
                this.setScrollAmount(this.contentHeight);
            } else {
                int size = class_3532.method_15340((int)(this.field_22759 * this.field_22759 / this.contentHeight), (int)0, (int)(this.field_22759 - 6));
                double scale = Math.max(1.0, (double)this.contentHeight / (double)(this.field_22759 - size));
                this.setScrollAmount(this.getScrollAmount() + (int)(deltaY * scale));
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.scrolling = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25395(@Nullable class_364 child) {
        super.method_25395(child);
        int i = this.children.indexOf(child);
        if (i >= 0 && this.minecraft.method_48186().method_48183()) {
            this.ensureVisible(i);
        }
    }

    protected int getEntryHeightSum(int index) {
        int sum = 0;
        for (int i = 0; i < index; ++i) {
            sum += this.entryHeights.getInt(i);
        }
        return sum;
    }

    protected int getRowTop(int index) {
        return this.method_46427() + 4 - this.getScrollAmount() + this.getEntryHeightSum(index);
    }

    public int getRowWidth() {
        return 310;
    }

    public void updateSize(int width, class_8132 headerAndFooterLayout) {
        this.updateSizeAndPosition(width, headerAndFooterLayout.method_57727(), headerAndFooterLayout.method_48998());
    }

    public void updateSizeAndPosition(int width, int height, int y) {
        this.method_55445(width, height);
        this.method_46419(y);
        this.update();
    }

    protected void ensureVisible(int index) {
        int rowTop3;
        int rowTop = this.getRowTop(index);
        int rowTop2 = rowTop - this.method_46427() - 4 - this.entryHeights.getInt(index);
        if (rowTop2 < 0) {
            this.setScrollAmount(this.getScrollAmount() + rowTop2);
        }
        if ((rowTop3 = this.method_46427() + this.field_22759 - rowTop - this.entryHeights.getInt(index) * 2) < 0) {
            this.setScrollAmount(this.getScrollAmount() - rowTop3);
        }
    }

    protected final Entry getEntryAtPosition(double x, double y) {
        int center = this.method_46426() + this.field_22758 / 2;
        int halfRowWidth = this.getRowWidth() / 2;
        int rowMinX = center - halfRowWidth;
        int rowMaxX = center + halfRowWidth;
        int sum = 0;
        int i = 0;
        while (sum <= class_3532.method_15357((double)(y - (double)this.method_46427())) + this.scrollAmount) {
            if (i < this.entryHeights.size()) {
                sum += this.entryHeights.getInt(i);
                ++i;
                continue;
            }
            ++i;
            break;
        }
        if (x < (double)this.getScrollBarPosX() && x >= (double)rowMinX && x <= (double)rowMaxX && --i < this.children.size()) {
            return this.children.get(i);
        }
        return null;
    }

    @Nullable
    protected Entry nextEntry(class_8028 direction, Predicate<Entry> predicate, @Nullable Entry currentEntry) {
        int i;
        switch (direction) {
            default: {
                throw new MatchException(null, null);
            }
            case field_41828: 
            case field_41829: {
                int n = 0;
                break;
            }
            case field_41826: {
                int n = -1;
                break;
            }
            case field_41827: {
                int n = i = 1;
            }
        }
        if (!this.children.isEmpty() && i != 0) {
            int j = currentEntry == null ? (i > 0 ? 0 : this.children.size() - 1) : this.children.indexOf(currentEntry) + i;
            for (int k = j; k >= 0 && k < this.children.size(); k += i) {
                Entry entry = this.children.get(k);
                if (!predicate.test(entry)) continue;
                return entry;
            }
        }
        return null;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        if (this.children.isEmpty()) {
            return null;
        }
        if (!(event instanceof class_8023.class_8024)) {
            return super.method_48205(event);
        }
        class_8023.class_8024 arrowNav = (class_8023.class_8024)event;
        Entry entry = this.getFocused();
        if (arrowNav.comp_1191().method_48237() == class_8027.field_41822 && entry != null) {
            return class_8016.method_48192((class_4069)this, (class_8016)entry.method_48205(event));
        }
        int i = -1;
        class_8028 navDir = arrowNav.comp_1191();
        if (entry != null) {
            i = entry.method_25396().indexOf(entry.method_25399());
        }
        if (i == -1) {
            switch (navDir) {
                case field_41828: {
                    i = Integer.MAX_VALUE;
                    navDir = class_8028.field_41827;
                    break;
                }
                case field_41829: {
                    i = 0;
                    navDir = class_8028.field_41827;
                    break;
                }
                default: {
                    i = 0;
                }
            }
        }
        Entry entry2 = entry;
        class_8016 path = null;
        while (path == null) {
            if ((entry2 = this.nextEntry(navDir, entryx -> !entryx.method_25396().isEmpty(), entry2)) == null) {
                return null;
            }
            path = entry2.getFocusPathAtIndex((class_8023)arrowNav, i);
        }
        return class_8016.method_48192((class_4069)this, path);
    }

    @Nullable
    public Entry getHovered() {
        return this.hovered;
    }

    public void addCategory(class_2561 component) {
        this.children.add(new CategoryEntry(component));
    }

    public void addButton(class_339 button) {
        this.children.add(new ButtonEntry(this, button));
    }

    public void addButton(class_339 leftButton, class_339 rightButton) {
        this.children.add(new ButtonEntry(this, leftButton, rightButton));
    }

    public void addServerEffectEntry(class_2561 component) {
        this.children.add(new ServerEffectEntry(this, component));
    }

    @ClientOnly
    public abstract class Entry
    implements class_4069 {
        @Nullable
        private class_364 focused;
        @Nullable
        private class_6379 lastNarratable;
        private boolean dragging;

        public abstract void render(class_332 var1, int var2, int var3, int var4, int var5, int var6, float var7);

        public abstract int getEntryHeight();

        public boolean method_25397() {
            return this.dragging;
        }

        public void method_25398(boolean dragging) {
            this.dragging = dragging;
        }

        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }

        public boolean method_25370() {
            return OkZoomerAbstractSelectionList.this.getFocused() == this;
        }

        public void method_25395(@Nullable class_364 focused) {
            if (this.focused != null) {
                this.focused.method_25365(false);
            }
            if (focused != null) {
                focused.method_25365(true);
            }
            this.focused = focused;
        }

        @Nullable
        public class_8016 getFocusPathAtIndex(class_8023 event, int index) {
            if (this.method_25396().isEmpty()) {
                return null;
            }
            class_8016 path = ((class_364)this.method_25396().get(Math.min(index, this.method_25396().size() - 1))).method_48205(event);
            return class_8016.method_48192((class_4069)this, (class_8016)path);
        }

        @Nullable
        public class_8016 method_48205(class_8023 event) {
            if (event instanceof class_8023.class_8024) {
                int j;
                int i;
                class_8023.class_8024 arrowNavigation = (class_8023.class_8024)event;
                switch (arrowNavigation.comp_1191()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case field_41828: {
                        int n = -1;
                        break;
                    }
                    case field_41829: {
                        int n = 1;
                        break;
                    }
                    case field_41826: 
                    case field_41827: {
                        int n = i = 0;
                    }
                }
                if (i == 0) {
                    return null;
                }
                for (int k = j = class_3532.method_15340((int)(i + this.method_25396().indexOf(this.method_25399())), (int)0, (int)(this.method_25396().size() - 1)); k >= 0 && k < this.method_25396().size(); k += i) {
                    class_364 guiEventListener = (class_364)this.method_25396().get(k);
                    class_8016 path = guiEventListener.method_48205(event);
                    if (path == null) continue;
                    return class_8016.method_48192((class_4069)this, (class_8016)path);
                }
            }
            return super.method_48205(event);
        }

        void updateNarration(class_6382 narrationElementOutput) {
            List<? extends class_6379> list = this.narratables();
            class_437.class_6390 narrationData = class_437.method_37061(list, (class_6379)this.lastNarratable);
            if (narrationData != null) {
                if (narrationData.field_33827.method_37028()) {
                    this.lastNarratable = narrationData.field_33825;
                }
                if (!list.isEmpty()) {
                    narrationElementOutput.method_37034(class_6381.field_33789, (class_2561)class_2561.method_43469((String)"narrator.position.object_list", (Object[])new Object[]{narrationData.field_33826 + 1, list.size()}));
                    if (narrationData.field_33827 == class_6379.class_6380.field_33786) {
                        narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.component_list.usage"));
                    }
                }
                narrationData.field_33825.method_37020(narrationElementOutput.method_37031());
            }
        }

        public abstract List<? extends class_6379> narratables();
    }

    @ClientOnly
    class CategoryEntry
    extends Entry {
        private final class_2561 title;

        private CategoryEntry(class_2561 title) {
            this.title = title;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
            graphics.method_25294(x, y + 1, x + rowWidth, y + 19, -1610612736);
            graphics.method_27534(OkZoomerAbstractSelectionList.this.minecraft.field_1772, this.title, x + rowWidth / 2, y + 6, -1);
        }

        @Override
        @Nullable
        public class_8016 method_48205(class_8023 event) {
            return null;
        }

        @Override
        public int getEntryHeight() {
            return 20;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return List.of();
        }

        @Override
        public List<? extends class_6379> narratables() {
            return List.of(new class_6379(){

                @NotNull
                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 narrationElementOutput) {
                    narrationElementOutput.method_37034(class_6381.field_33788, CategoryEntry.this.title);
                }
            });
        }
    }

    @ClientOnly
    class ButtonEntry
    extends Entry {
        private final class_339 leftButton;
        private final class_339 rightButton;
        private final int entryHeight;
        private final List<class_339> buttons;

        public ButtonEntry(OkZoomerAbstractSelectionList this$0, class_339 button) {
            button.method_25358(310);
            this.leftButton = button;
            this.rightButton = null;
            this.entryHeight = button.method_25364() + 4;
            this.buttons = List.of(button);
        }

        public ButtonEntry(OkZoomerAbstractSelectionList this$0, class_339 leftButton, class_339 rightButton) {
            this.leftButton = leftButton;
            this.rightButton = rightButton;
            this.entryHeight = (rightButton != null ? Math.max(leftButton.method_25364(), rightButton.method_25364()) : leftButton.method_25364()) + 4;
            this.buttons = rightButton != null ? List.of(leftButton, rightButton) : List.of(leftButton);
        }

        @Override
        public void render(class_332 graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
            this.leftButton.method_48229(x, y + 2);
            this.leftButton.method_25394(graphics, mouseX, mouseY, delta);
            if (this.rightButton != null) {
                this.rightButton.method_48229(x + 160, y + 2);
                this.rightButton.method_25394(graphics, mouseX, mouseY, delta);
            }
        }

        @Override
        public int getEntryHeight() {
            return this.entryHeight;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.buttons;
        }

        @Override
        public List<? extends class_6379> narratables() {
            return this.buttons;
        }
    }

    @ClientOnly
    class ServerEffectEntry
    extends Entry {
        private final class_5489 serverEffect;
        private final class_2561 serverEffectText;
        private int lines = 16;

        private ServerEffectEntry(OkZoomerAbstractSelectionList this$0, class_2561 serverEffect) {
            this.serverEffect = class_5489.method_30890((class_327)this$0.minecraft.field_1772, (class_2561)serverEffect, (int)310);
            this.serverEffectText = serverEffect;
        }

        @Override
        public void render(class_332 graphics, int x, int y, int rowWidth, int mouseX, int mouseY, float delta) {
            this.serverEffect.method_30889(graphics, x + rowWidth / 2, y + 4, 9, -1);
            this.lines = this.serverEffect.method_30887() * 9 + 7;
        }

        @Override
        @Nullable
        public class_8016 method_48205(class_8023 event) {
            return null;
        }

        @Override
        public int getEntryHeight() {
            return this.lines;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return List.of();
        }

        @Override
        public List<? extends class_6379> narratables() {
            return List.of(new class_6379(){

                @NotNull
                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 narrationElementOutput) {
                    narrationElementOutput.method_37034(class_6381.field_33788, ServerEffectEntry.this.serverEffectText);
                }
            });
        }
    }
}

