/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.packets;

import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.packets.payloads.AcknowledgeModPacket;
import io.github.ennuil.ok_zoomer.packets.payloads.DisableZoomPacket;
import io.github.ennuil.ok_zoomer.packets.payloads.DisableZoomScrollingPacket;
import io.github.ennuil.ok_zoomer.packets.payloads.ForceClassicModePacket;
import io.github.ennuil.ok_zoomer.packets.payloads.ForceSpyglassOverlayPacket;
import io.github.ennuil.ok_zoomer.packets.payloads.ForceSpyglassPacket;
import io.github.ennuil.ok_zoomer.packets.payloads.ForceZoomDivisorPacket;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class ZoomPackets {
    private static boolean hasRestrictions = false;
    private static boolean disableZoom = false;
    private static boolean disableZoomScrolling = false;
    private static boolean forceClassicMode = false;
    private static boolean forceZoomDivisors = false;
    private static Acknowledgement acknowledgement = Acknowledgement.NONE;
    private static double maximumZoomDivisor = 0.0;
    private static double minimumZoomDivisor = 0.0;
    private static boolean forceSpyglassMode = false;
    private static boolean forceSpyglassOverlay = false;
    private static final class_2561 TOAST_TITLE = class_2561.method_43471((String)"toast.ok_zoomer.title");

    public static void applyDisableZooming() {
        disableZoom = true;
    }

    public static void sendToast(class_2561 description) {
        ZoomPackets.sendToast(class_310.method_1551(), description);
    }

    public static void sendToast(class_310 minecraft, class_2561 description) {
        if (((Boolean)OkZoomerConfigManager.CONFIG.tweaks.showRestrictionToasts.value()).booleanValue()) {
            minecraft.method_1566().method_1999((class_368)class_370.method_29047((class_310)minecraft, (class_370.class_9037)ZoomUtils.TOAST_ID, (class_2561)TOAST_TITLE, (class_2561)description));
        }
    }

    private static <T extends class_8710> void registerConfigurationPacket(class_8710.class_9154<T> type, class_9139<class_2540, T> streamCodec, ClientConfigurationNetworking.ConfigurationPayloadHandler<T> handler) {
        PayloadTypeRegistry.configurationS2C().register(type, streamCodec);
        ClientConfigurationNetworking.registerGlobalReceiver(type, handler);
    }

    public static void registerPackets() {
        ZoomPackets.registerConfigurationPacket(DisableZoomPacket.TYPE, DisableZoomPacket.STREAM_CODEC, DisableZoomPacket::handle);
        ZoomPackets.registerConfigurationPacket(DisableZoomScrollingPacket.TYPE, DisableZoomScrollingPacket.STREAM_CODEC, DisableZoomScrollingPacket::handle);
        ZoomPackets.registerConfigurationPacket(ForceClassicModePacket.TYPE, ForceClassicModePacket.STREAM_CODEC, ForceClassicModePacket::handle);
        ZoomPackets.registerConfigurationPacket(ForceZoomDivisorPacket.TYPE, ForceZoomDivisorPacket.STREAM_CODEC, ForceZoomDivisorPacket::handle);
        ZoomPackets.registerConfigurationPacket(AcknowledgeModPacket.TYPE, AcknowledgeModPacket.STREAM_CODEC, AcknowledgeModPacket::handle);
        ZoomPackets.registerConfigurationPacket(ForceSpyglassPacket.TYPE, ForceSpyglassPacket.STREAM_CODEC, ForceSpyglassPacket::handle);
        ZoomPackets.registerConfigurationPacket(ForceSpyglassOverlayPacket.TYPE, ForceSpyglassOverlayPacket.STREAM_CODEC, ForceSpyglassOverlayPacket::handle);
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (hasRestrictions) {
                ZoomPackets.resetPacketSignals();
            }
        });
    }

    public static boolean hasRestrictions() {
        return hasRestrictions;
    }

    public static void checkRestrictions() {
        boolean hasRestrictions;
        ZoomPackets.hasRestrictions = hasRestrictions = disableZoom || disableZoomScrolling || forceClassicMode || forceZoomDivisors || forceSpyglassMode || forceSpyglassOverlay;
        acknowledgement = hasRestrictions ? Acknowledgement.HAS_RESTRICTIONS : Acknowledgement.HAS_NO_RESTRICTIONS;
    }

    public static boolean shouldDisableZoom() {
        return disableZoom;
    }

    public static boolean shouldDisableZoomScrolling() {
        return disableZoomScrolling;
    }

    public static boolean shouldForceClassicMode() {
        return forceClassicMode;
    }

    public static boolean shouldForceZoomDivisors() {
        return forceZoomDivisors;
    }

    public static Acknowledgement getAcknowledgement() {
        return acknowledgement;
    }

    public static double getMaximumZoomDivisor() {
        return maximumZoomDivisor;
    }

    public static double getMinimumZoomDivisor() {
        return minimumZoomDivisor;
    }

    public static boolean shouldForceSpyglassMode() {
        return forceSpyglassMode;
    }

    public static boolean shouldForceSpyglassOverlay() {
        return forceSpyglassOverlay;
    }

    public static void applyDisableZoomScrolling() {
        disableZoomScrolling = true;
        OkZoomerConfigManager.CONFIG.features.zoomScrolling.setOverride((Object)false);
        OkZoomerConfigManager.CONFIG.features.extraKeyBinds.setOverride((Object)false);
    }

    public static void applyClassicMode() {
        forceClassicMode = true;
        ZoomPackets.applyDisableZoomScrolling();
        OkZoomerConfigManager.CONFIG.features.cinematicCamera.setOverride((Object)ConfigEnums.CinematicCameraOptions.VANILLA);
        OkZoomerConfigManager.CONFIG.features.reduceSensitivity.setOverride((Object)false);
        OkZoomerConfigManager.CONFIG.zoomValues.zoomDivisor.setOverride((Object)4.0);
        OkZoomerConfigManager.configureZoomInstance();
    }

    public static void applyForcedZoomDivisor(double max, double min) {
        maximumZoomDivisor = max;
        minimumZoomDivisor = min;
        forceZoomDivisors = true;
    }

    public static void applySpyglassDependency(boolean requireItem, boolean replaceZoom) {
        OkZoomerConfigManager.CONFIG.features.spyglassMode.setOverride((Object)(requireItem ? (replaceZoom ? ConfigEnums.SpyglassMode.BOTH : ConfigEnums.SpyglassMode.REQUIRE_ITEM) : (replaceZoom ? ConfigEnums.SpyglassMode.REPLACE_ZOOM : null)));
        forceSpyglassMode = true;
    }

    public static void applyForceSpyglassOverlay() {
        OkZoomerConfigManager.CONFIG.features.zoomOverlay.setOverride((Object)ConfigEnums.ZoomOverlays.SPYGLASS);
        forceSpyglassOverlay = true;
    }

    private static void resetPacketSignals() {
        hasRestrictions = false;
        disableZoom = false;
        disableZoomScrolling = false;
        OkZoomerConfigManager.CONFIG.features.zoomScrolling.removeOverride();
        OkZoomerConfigManager.CONFIG.features.extraKeyBinds.removeOverride();
        forceClassicMode = false;
        OkZoomerConfigManager.CONFIG.features.cinematicCamera.removeOverride();
        OkZoomerConfigManager.CONFIG.features.reduceSensitivity.removeOverride();
        OkZoomerConfigManager.CONFIG.zoomValues.zoomDivisor.removeOverride();
        forceZoomDivisors = false;
        maximumZoomDivisor = 0.0;
        minimumZoomDivisor = 0.0;
        acknowledgement = Acknowledgement.NONE;
        forceSpyglassMode = false;
        OkZoomerConfigManager.CONFIG.features.spyglassMode.removeOverride();
        forceSpyglassOverlay = false;
        OkZoomerConfigManager.CONFIG.features.zoomScrolling.removeOverride();
    }

    public static enum Acknowledgement {
        NONE,
        HAS_RESTRICTIONS,
        HAS_NO_RESTRICTIONS;

    }
}

