/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.packets.payloads;

import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.packets.ZoomPackets;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import io.github.ennuil.ok_zoomer.utils.ZoomUtils;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.quiltmc.loader.api.minecraft.ClientOnly;

public record ForceZoomDivisorPacket(double max, double min) implements class_8710
{
    public static final class_9139<class_2540, ForceZoomDivisorPacket> STREAM_CODEC = class_8710.method_56484(ForceZoomDivisorPacket::write, ForceZoomDivisorPacket::new);
    public static final class_8710.class_9154<ForceZoomDivisorPacket> TYPE = new class_8710.class_9154(ModUtils.id("force_zoom_divisor"));

    public ForceZoomDivisorPacket(class_2540 buf) {
        this(buf.readDouble(), buf.readableBytes() >= 8 ? buf.readDouble() : buf.getDouble(0));
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void write(class_2540 buffer) {
        buffer.method_52940(this.max());
        buffer.method_52940(this.min());
    }

    @ClientOnly
    public static void handle(ForceZoomDivisorPacket payload, ClientConfigurationNetworking.Context context) {
        if (payload.min() <= 0.0 || payload.max() <= 0.0 || payload.min() > payload.max()) {
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has attempted to set invalid divisor values! (min {}, max {})", (Object)payload.min(), (Object)payload.max());
        } else {
            ZoomUtils.LOGGER.info("[Ok Zoomer] This server has set the zoom divisors to minimum {} and maximum {}", (Object)payload.min(), (Object)payload.max());
            ZoomPackets.applyForcedZoomDivisor(payload.max(), payload.min());
            OkZoomerConfigManager.configureZoomInstance();
            ZoomPackets.checkRestrictions();
        }
    }
}

