/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.zoom;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.ennuil.libzoomer.api.ZoomOverlay;
import io.github.ennuil.ok_zoomer.config.ConfigEnums;
import io.github.ennuil.ok_zoomer.config.OkZoomerConfigManager;
import io.github.ennuil.ok_zoomer.utils.ModUtils;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class ZoomerZoomOverlay
implements ZoomOverlay {
    private static final class_2960 OVERLAY_ID = ModUtils.id("zoom_overlay");
    private final class_2960 textureId;
    private boolean active;
    private final class_310 minecraft;
    public float zoomOverlayAlpha = 0.0f;
    public float lastZoomOverlayAlpha = 0.0f;

    public ZoomerZoomOverlay(class_2960 textureId) {
        this.textureId = textureId;
        this.active = false;
        this.minecraft = class_310.method_1551();
    }

    public class_2960 getId() {
        return OVERLAY_ID;
    }

    public boolean getActive() {
        return this.active;
    }

    public void renderOverlay(class_332 graphics) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        float lerpedOverlayAlpha = class_3532.method_16439((float)this.minecraft.method_60646().method_60637(true), (float)this.lastZoomOverlayAlpha, (float)this.zoomOverlayAlpha);
        RenderSystem.setShaderColor((float)lerpedOverlayAlpha, (float)lerpedOverlayAlpha, (float)lerpedOverlayAlpha, (float)1.0f);
        graphics.method_25291(this.textureId, 0, 0, -90, 0.0f, 0.0f, graphics.method_51421(), graphics.method_51443(), graphics.method_51421(), graphics.method_51443());
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public void tick(boolean active, double divisor, double transitionMultiplier) {
        if (active || this.zoomOverlayAlpha == 0.0f) {
            this.active = active;
        }
        float zoomMultiplier = active ? 1.0f : 0.0f;
        this.lastZoomOverlayAlpha = this.zoomOverlayAlpha;
        if (((ConfigEnums.ZoomTransitionOptions)OkZoomerConfigManager.CONFIG.features.zoomTransition.value()).equals(ConfigEnums.ZoomTransitionOptions.SMOOTH)) {
            this.zoomOverlayAlpha += (float)((double)(zoomMultiplier - this.zoomOverlayAlpha) * (Double)OkZoomerConfigManager.CONFIG.transitionValues.smoothTransitionFactor.value());
        } else if (((ConfigEnums.ZoomTransitionOptions)OkZoomerConfigManager.CONFIG.features.zoomTransition.value()).equals(ConfigEnums.ZoomTransitionOptions.LINEAR)) {
            double linearStep = class_3532.method_15350((double)(1.0 / divisor), (double)((Double)OkZoomerConfigManager.CONFIG.transitionValues.minimumLinearStep.value()), (double)((Double)OkZoomerConfigManager.CONFIG.transitionValues.maximumLinearStep.value()));
            this.zoomOverlayAlpha = class_3532.method_15348((float)this.zoomOverlayAlpha, (float)zoomMultiplier, (float)((float)linearStep));
        }
    }
}

