/*
 * Decompiled with CFR 0.152.
 */
package me.obsilabor.tpshud;

import java.util.Arrays;
import me.obsilabor.alert.Subscribe;
import me.obsilabor.tpshud.config.ConfigManager;
import me.obsilabor.tpshud.event.GameJoinEvent;
import me.obsilabor.tpshud.event.PacketReceiveEvent;
import net.minecraft.class_2761;
import net.minecraft.class_310;

public class TpsTracker {
    public static TpsTracker INSTANCE = new TpsTracker();
    private final float[] tickRates = new float[20];
    private int nextIndex = 0;
    private long timeLastTimeUpdate = -1L;
    private long timeGameJoined;
    public float serverProvidedTps = -1.0f;

    @Subscribe
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacket() instanceof class_2761) {
            long now = System.currentTimeMillis();
            float timeElapsed = (float)(now - this.timeLastTimeUpdate) / 1000.0f;
            this.tickRates[this.nextIndex] = this.clamp(20.0f / timeElapsed, 0.0f, 20.0f);
            this.nextIndex = (this.nextIndex + 1) % this.tickRates.length;
            this.timeLastTimeUpdate = now;
        }
    }

    @Subscribe
    public void onGameJoined(GameJoinEvent event) {
        this.serverProvidedTps = -1.0f;
        Arrays.fill(this.tickRates, 0.0f);
        this.nextIndex = 0;
        this.timeGameJoined = this.timeLastTimeUpdate = System.currentTimeMillis();
    }

    public float getTickRate() {
        class_310 minecraft = class_310.method_1551();
        if (this.serverProvidedTps != -1.0f && !minecraft.field_1687.field_9236 && ConfigManager.INSTANCE.getConfig().getUseServerProvidedData().booleanValue()) {
            return this.serverProvidedTps;
        }
        if (minecraft.field_1724 == null) {
            return 0.0f;
        }
        if (System.currentTimeMillis() - this.timeGameJoined < 4000L) {
            return 20.0f;
        }
        int numTicks = 0;
        float sumTickRates = 0.0f;
        for (float tickRate : this.tickRates) {
            if (!(tickRate > 0.0f)) continue;
            sumTickRates += tickRate;
            ++numTicks;
        }
        return sumTickRates / (float)numTicks;
    }

    private float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }
}

