/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.service.Platform;
import dynamic_fps.impl.util.JsonUtil;
import dynamic_fps.impl.util.Logging;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Serialization {
    private static final String CONFIG_FILE = "dynamic_fps.json";

    public static void save() {
        JsonObject config = (JsonObject)JsonUtil.toJsonTree(DynamicFPSConfig.INSTANCE);
        JsonObject parent = (JsonObject)JsonUtil.toJsonTree(DynamicFPSConfig.DEFAULTS);
        String data = JsonUtil.toJson((JsonElement)Serialization.removeUnchangedFields(config, parent));
        try {
            Serialization.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save or modify Dynamic FPS config!", e);
        }
    }

    private static void write(String data) throws IOException {
        data = (String)data + "\n";
        Platform platform = Platform.getInstance();
        Path cache = Platform.getInstance().getCacheDir();
        Path maybe = Files.createTempFile(cache, "config", ".json", new FileAttribute[0]);
        Files.write(maybe, ((String)data).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Serialization.move(maybe, platform.getConfigDir().resolve(CONFIG_FILE));
    }

    private static void move(Path from, Path to) throws IOException {
        try {
            Files.move(from, to, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException | UnsupportedOperationException e) {
            Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static JsonObject removeUnchangedFields(JsonObject config, JsonObject parent) {
        parent.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            JsonElement other = (JsonElement)entry.getValue();
            JsonElement value = config.get(name);
            if (value == null) {
                return;
            }
            if (value.isJsonObject() && other.isJsonObject()) {
                Serialization.removeUnchangedFields((JsonObject)value, (JsonObject)other);
            }
            if (value.equals(other) || value.isJsonObject() && value.getAsJsonObject().size() == 0) {
                config.remove(name);
            }
        });
        return config;
    }

    public static DynamicFPSConfig loadPersonalized() {
        JsonObject root;
        byte[] data = null;
        Path config = Platform.getInstance().getConfigDir().resolve(CONFIG_FILE);
        try {
            data = Files.readAllBytes(config);
        }
        catch (NoSuchFileException e) {
            try {
                Serialization.write("{}");
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load Dynamic FPS config.", e);
        }
        if (data == null || data[0] == 0) {
            root = new JsonObject();
            Logging.getLogger().warn("Dynamic FPS config missing or corrupted! Using defaults.");
        } else {
            root = (JsonObject)new JsonParser().parse(new String(data, StandardCharsets.UTF_8));
        }
        Serialization.upgradeConfig(root);
        return JsonUtil.fromJson((JsonElement)root, DynamicFPSConfig.class);
    }

    public static DynamicFPSConfig loadDefault() {
        byte[] data;
        try (InputStream stream = Serialization.class.getResourceAsStream("/assets/dynamic_fps/data/default_config.json");){
            if (stream == null) {
                throw new IOException("Stream is null.");
            }
            data = stream.readAllBytes();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load Dynamic FPS config.", e);
        }
        return JsonUtil.fromJson(new String(data, StandardCharsets.UTF_8), DynamicFPSConfig.class);
    }

    private static void upgradeConfig(JsonObject config) {
        Serialization.upgradeVolumeMultiplier(config);
        Serialization.upgradeIdleConfig(config);
        Serialization.addMissingFields(config, (JsonObject)JsonUtil.toJsonTree(DynamicFPSConfig.DEFAULTS));
    }

    private static void addMissingFields(JsonObject config, JsonObject parent) {
        parent.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            JsonElement other = (JsonElement)entry.getValue();
            JsonElement value = config.get(name);
            if (value == null) {
                config.add(name, other);
            } else if (value.isJsonObject() && other.isJsonObject()) {
                Serialization.addMissingFields((JsonObject)value, (JsonObject)other);
            }
        });
    }

    private static void upgradeVolumeMultiplier(JsonObject root) {
        JsonObject states = Serialization.getStatesAsObject(root);
        if (states == null) {
            return;
        }
        for (Map.Entry entry : states.entrySet()) {
            JsonElement multiplier;
            JsonObject element;
            JsonElement value = (JsonElement)entry.getValue();
            if (!value.isJsonObject() || !(element = value.getAsJsonObject()).has("volume_multiplier") || !(multiplier = element.get("volume_multiplier")).isJsonPrimitive() || !((JsonPrimitive)multiplier).isNumber()) continue;
            JsonObject multipliers = new JsonObject();
            multipliers.add("master", multiplier);
            element.add("volume_multipliers", (JsonElement)multipliers);
        }
    }

    private static void upgradeIdleConfig(JsonObject root) {
        if (!root.has("idle_time")) {
            return;
        }
        JsonElement idleTime = root.get("idle_time");
        if (!idleTime.isJsonPrimitive() || !idleTime.getAsJsonPrimitive().isNumber()) {
            return;
        }
        int timeout = idleTime.getAsInt();
        if (timeout == 0) {
            return;
        }
        JsonObject idle = new JsonObject();
        idle.addProperty("timeout", (Number)timeout);
        idle.addProperty("condition", "none");
        root.add("idle", (JsonElement)idle);
    }

    @Nullable
    private static JsonObject getStatesAsObject(JsonObject root) {
        if (!root.has("states")) {
            return null;
        }
        if (!root.get("states").isJsonObject()) {
            return null;
        }
        return root.getAsJsonObject("states");
    }
}

