/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compatibility.checks;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import me.jellysquid.mods.sodium.client.compatibility.checks.BugChecks;
import me.jellysquid.mods.sodium.client.platform.MessageBox;
import me.jellysquid.mods.sodium.client.platform.windows.WindowsFileVersion;
import me.jellysquid.mods.sodium.client.platform.windows.api.Kernel32;
import me.jellysquid.mods.sodium.client.platform.windows.api.version.Version;
import me.jellysquid.mods.sodium.client.platform.windows.api.version.VersionFixedFileInfoStruct;
import me.jellysquid.mods.sodium.client.platform.windows.api.version.VersionInfo;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_6498;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-Win32ModuleChecks");
    private static final String[] RTSS_HOOKS_MODULE_NAMES = new String[]{"RTSSHooks64.dll", "RTSSHooks.dll"};

    public static void checkModules() {
        List modules;
        try {
            modules = class_6498.method_37961();
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to scan the currently loaded modules", t);
            return;
        }
        if (modules.isEmpty()) {
            return;
        }
        if (BugChecks.ISSUE_2048 && ModuleScanner.isModuleLoaded(modules, RTSS_HOOKS_MODULE_NAMES)) {
            ModuleScanner.checkRTSSModules();
        }
    }

    private static void checkRTSSModules() {
        LOGGER.warn("RivaTuner Statistics Server (RTSS) has injected into the process! Attempting to apply workarounds for compatibility...");
        @Nullable WindowsFileVersion version = null;
        try {
            version = ModuleScanner.findRTSSModuleVersion();
        }
        catch (Throwable t) {
            LOGGER.warn("Exception thrown while reading file version", t);
        }
        if (version == null) {
            LOGGER.warn("Could not determine version of RivaTuner Statistics Server");
        } else {
            LOGGER.info("Detected RivaTuner Statistics Server version: {}", (Object)version);
        }
        if (version == null || !ModuleScanner.isRTSSCompatible(version)) {
            class_1041 window = class_310.method_1551().method_22683();
            MessageBox.showMessageBox(window, MessageBox.IconType.ERROR, "Sodium Renderer", "You appear to be using an older version of RivaTuner Statistics Server (RTSS) which is not compatible with Sodium.\n\nYou must either update to a newer version (7.3.4 and later) or close the RivaTuner Statistics Server application.\n\nFor more information on how to solve this problem, click the 'Help' button.", "https://github.com/CaffeineMC/sodium-fabric/wiki/Known-Issues#rtss-incompatible");
            throw new RuntimeException("The installed version of RivaTuner Statistics Server (RTSS) is not compatible with Sodium, see here for more details: https://github.com/CaffeineMC/sodium-fabric/wiki/Known-Issues#rtss-incompatible");
        }
    }

    private static boolean isRTSSCompatible(WindowsFileVersion version) {
        int x = version.x();
        int y = version.y();
        int z = version.z();
        return x > 7 || x == 7 && y > 3 || x == 7 && y == 3 && z >= 4;
    }

    @Nullable
    private static WindowsFileVersion findRTSSModuleVersion() {
        String moduleFileName;
        long module;
        try {
            module = Kernel32.getModuleHandleByNames(RTSS_HOOKS_MODULE_NAMES);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to locate module", t);
            return null;
        }
        try {
            moduleFileName = Kernel32.getModuleFileName(module);
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to get path of module", t);
            return null;
        }
        Path modulePath = Path.of(moduleFileName, new String[0]);
        Path moduleDirectory = modulePath.getParent();
        LOGGER.info("Searching directory: {}", (Object)moduleDirectory);
        Path executablePath = moduleDirectory.resolve("RTSS.exe");
        if (!Files.exists(executablePath, new LinkOption[0])) {
            LOGGER.warn("Could not find executable: {}", (Object)executablePath);
            return null;
        }
        LOGGER.info("Parsing file: {}", (Object)executablePath);
        VersionInfo version = Version.getModuleFileVersion(executablePath.toAbsolutePath().toString());
        if (version == null) {
            LOGGER.warn("Couldn't find version structure");
            return null;
        }
        VersionFixedFileInfoStruct fileVersion = version.queryFixedFileInfo();
        if (fileVersion == null) {
            LOGGER.warn("Couldn't query file version");
            return null;
        }
        return WindowsFileVersion.fromFileVersion(fileVersion);
    }

    private static boolean isModuleLoaded(List<class_6498.class_6499> modules, String[] names) {
        for (String name : names) {
            for (class_6498.class_6499 module : modules) {
                if (!module.field_34396.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }
}

