/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import me.jellysquid.mods.sodium.client.world.BiomeSeedProvider;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_3532;
import net.minecraft.class_4540;
import net.minecraft.class_5742;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7924;

public class BiomeSlice {
    private static final int SIZE = 12;
    private final class_6880<class_1959>[] biomes = new class_6880[1728];
    private final boolean[] uniform = new boolean[1728];
    private final BiasMap bias = new BiasMap();
    private long biomeSeed;
    private int worldX;
    private int worldY;
    private int worldZ;

    public void update(class_638 world, ChunkRenderContext context) {
        this.worldX = context.getOrigin().method_19527() - 16;
        this.worldY = context.getOrigin().method_19528() - 16;
        this.worldZ = context.getOrigin().method_19529() - 16;
        this.biomeSeed = BiomeSeedProvider.getBiomeSeed(world);
        this.copyBiomeData((class_1937)world, context);
        this.calculateBias();
        this.calculateUniform();
    }

    private void copyBiomeData(class_1937 world, ChunkRenderContext context) {
        class_6880.class_6883 defaultValue = world.method_30349().method_30530(class_7924.field_41236).method_40290(class_1972.field_9451);
        for (int sectionX = 0; sectionX < 3; ++sectionX) {
            for (int sectionY = 0; sectionY < 3; ++sectionY) {
                for (int sectionZ = 0; sectionZ < 3; ++sectionZ) {
                    this.copySectionBiomeData(context, sectionX, sectionY, sectionZ, (class_6880<class_1959>)defaultValue);
                }
            }
        }
    }

    private void copySectionBiomeData(ChunkRenderContext context, int sectionX, int sectionY, int sectionZ, class_6880<class_1959> defaultBiome) {
        ClonedChunkSection section = context.getSections()[WorldSlice.getLocalSectionIndex(sectionX, sectionY, sectionZ)];
        class_7522<class_6880<class_1959>> biomeData = section.getBiomeData();
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    int biomeX = sectionX * 4 + x;
                    int biomeY = sectionY * 4 + y;
                    int biomeZ = sectionZ * 4 + z;
                    int idx = BiomeSlice.dataArrayIndex(biomeX, biomeY, biomeZ);
                    this.biomes[idx] = biomeData == null ? defaultBiome : (class_6880)biomeData.method_12321(x, y, z);
                }
            }
        }
    }

    private void calculateUniform() {
        for (int x = 2; x < 10; ++x) {
            for (int y = 2; y < 10; ++y) {
                for (int z = 2; z < 10; ++z) {
                    this.uniform[BiomeSlice.dataArrayIndex((int)x, (int)y, (int)z)] = this.hasUniformNeighbors(x, y, z);
                }
            }
        }
    }

    private void calculateBias() {
        int offsetX = this.worldX >> 2;
        int offsetY = this.worldY >> 2;
        int offsetZ = this.worldZ >> 2;
        long seed = this.biomeSeed;
        for (int cellX = 1; cellX < 11; ++cellX) {
            int worldCellX = offsetX + cellX;
            long seedX = class_4540.method_22372((long)seed, (long)worldCellX);
            for (int cellY = 1; cellY < 11; ++cellY) {
                int worldCellY = offsetY + cellY;
                long seedXY = class_4540.method_22372((long)seedX, (long)worldCellY);
                for (int cellZ = 1; cellZ < 11; ++cellZ) {
                    int worldCellZ = offsetZ + cellZ;
                    long seedXYZ = class_4540.method_22372((long)seedXY, (long)worldCellZ);
                    this.calculateBias(BiomeSlice.dataArrayIndex(cellX, cellY, cellZ), worldCellX, worldCellY, worldCellZ, seedXYZ);
                }
            }
        }
    }

    private void calculateBias(int index, int x, int y, int z, long seed) {
        seed = class_4540.method_22372((long)seed, (long)x);
        seed = class_4540.method_22372((long)seed, (long)y);
        seed = class_4540.method_22372((long)seed, (long)z);
        int gradX = BiomeSlice.getBias(seed);
        seed = class_4540.method_22372((long)seed, (long)this.biomeSeed);
        int gradY = BiomeSlice.getBias(seed);
        seed = class_4540.method_22372((long)seed, (long)this.biomeSeed);
        int gradZ = BiomeSlice.getBias(seed);
        this.bias.set(index, gradX, gradY, gradZ);
    }

    private boolean hasUniformNeighbors(int x, int y, int z) {
        class_1959 biome = (class_1959)this.biomes[BiomeSlice.dataArrayIndex(x, y, z)].comp_349();
        int minX = x - 1;
        int maxX = x + 1;
        int minY = y - 1;
        int maxY = y + 1;
        int minZ = z - 1;
        int maxZ = z + 1;
        for (int adjX = minX; adjX <= maxX; ++adjX) {
            for (int adjY = minY; adjY <= maxY; ++adjY) {
                for (int adjZ = minZ; adjZ <= maxZ; ++adjZ) {
                    if (this.biomes[BiomeSlice.dataArrayIndex(adjX, adjY, adjZ)].comp_349() == biome) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public class_6880<class_1959> getBiome(int x, int y, int z) {
        int relX = x - this.worldX;
        int relY = y - this.worldY;
        int relZ = z - this.worldZ;
        int centerIndex = BiomeSlice.dataArrayIndex(class_5742.method_33100((int)(relX - 2)), class_5742.method_33100((int)(relY - 2)), class_5742.method_33100((int)(relZ - 2)));
        if (this.uniform[centerIndex]) {
            return this.biomes[centerIndex];
        }
        return this.getBiomeUsingVoronoi(relX, relY, relZ);
    }

    private class_6880<class_1959> getBiomeUsingVoronoi(int worldX, int worldY, int worldZ) {
        int x = worldX - 2;
        int y = worldY - 2;
        int z = worldZ - 2;
        int intX = class_5742.method_33100((int)x);
        int intY = class_5742.method_33100((int)y);
        int intZ = class_5742.method_33100((int)z);
        float fracX = (float)class_5742.method_39920((int)x) * 0.25f;
        float fracY = (float)class_5742.method_39920((int)y) * 0.25f;
        float fracZ = (float)class_5742.method_39920((int)z) * 0.25f;
        float closestDistance = Float.POSITIVE_INFINITY;
        int closestArrayIndex = 0;
        for (int index = 0; index < 8; ++index) {
            float distanceZ;
            float distanceY;
            boolean dirX = (index & 4) != 0;
            boolean dirY = (index & 2) != 0;
            boolean dirZ = (index & 1) != 0;
            int adjIntX = intX + (dirX ? 1 : 0);
            int adjIntY = intY + (dirY ? 1 : 0);
            int adjIntZ = intZ + (dirZ ? 1 : 0);
            float adjFracX = fracX - (dirX ? 1.0f : 0.0f);
            float adjFracY = fracY - (dirY ? 1.0f : 0.0f);
            float adjFracZ = fracZ - (dirZ ? 1.0f : 0.0f);
            int biasIndex = BiomeSlice.dataArrayIndex(adjIntX, adjIntY, adjIntZ);
            float biasX = BiomeSlice.biasToVector(this.bias.getX(biasIndex));
            float biasY = BiomeSlice.biasToVector(this.bias.getY(biasIndex));
            float biasZ = BiomeSlice.biasToVector(this.bias.getZ(biasIndex));
            float distanceX = class_3532.method_27285((float)(adjFracX + biasX));
            float distance = distanceX + (distanceY = class_3532.method_27285((float)(adjFracY + biasY))) + (distanceZ = class_3532.method_27285((float)(adjFracZ + biasZ)));
            if (!(closestDistance > distance)) continue;
            closestArrayIndex = biasIndex;
            closestDistance = distance;
        }
        return this.biomes[closestArrayIndex];
    }

    private static int dataArrayIndex(int x, int y, int z) {
        return x * 12 * 12 + y * 12 + z;
    }

    private static float biasToVector(int bias) {
        return (float)bias * 9.765625E-4f * 0.9f;
    }

    private static int getBias(long l) {
        return (int)((l >> 24 & 0x3FFL) - 512L);
    }

    public static class BiasMap {
        private final short[] data = new short[5184];

        public void set(int index, int x, int y, int z) {
            this.data[index * 3 + 0] = (short)x;
            this.data[index * 3 + 1] = (short)y;
            this.data[index * 3 + 2] = (short)z;
        }

        public int getX(int index) {
            return this.data[index * 3 + 0];
        }

        public int getY(int index) {
            return this.data[index * 3 + 1];
        }

        public int getZ(int index) {
            return this.data[index * 3 + 2];
        }
    }
}

