/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigColorList;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigColorList
extends ConfigBase<ConfigColorList>
implements IConfigColorList {
    private final ImmutableList<Color4f> defaultValue;
    private final List<Color4f> colors = new ArrayList<Color4f>();

    public ConfigColorList(String name, ImmutableList<Color4f> defaultValue, String comment) {
        super(ConfigType.COLOR_LIST, name, comment);
        this.defaultValue = defaultValue;
        this.colors.addAll((Collection<Color4f>)defaultValue);
    }

    public ConfigColorList(String name, ImmutableList<Color4f> defaultValue, String comment, String prettyName) {
        super(ConfigType.COLOR_LIST, name, comment, prettyName);
        this.defaultValue = defaultValue;
        this.colors.addAll((Collection<Color4f>)defaultValue);
    }

    @Override
    public List<Color4f> getColors() {
        return this.colors;
    }

    @Override
    public ImmutableList<Color4f> getDefaultColors() {
        return this.defaultValue;
    }

    @Override
    public void setColors(List<Color4f> colors) {
        if (!this.colors.equals(colors)) {
            this.colors.clear();
            this.colors.addAll(colors);
            this.onValueChanged();
        }
    }

    @Override
    public void resetToDefault() {
        this.setColors((List<Color4f>)this.defaultValue);
    }

    @Override
    public boolean isModified() {
        return !this.colors.equals(this.defaultValue);
    }

    @Override
    public void setValueFromJsonElement(JsonElement element) {
        this.colors.clear();
        try {
            if (element.isJsonArray()) {
                JsonArray arr = element.getAsJsonArray();
                int count = arr.size();
                for (int i = 0; i < count; ++i) {
                    this.colors.add(Color4f.fromColor(StringUtils.getColor(arr.get(i).getAsString(), 0)));
                }
            } else {
                MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element);
            }
        }
        catch (Exception e) {
            MaLiLib.logger.warn("Failed to set config value for '{}' from the JSON element '{}'", (Object)this.getName(), (Object)element, (Object)e);
        }
    }

    @Override
    public JsonElement getAsJsonElement() {
        JsonArray arr = new JsonArray();
        for (Color4f color4f : this.colors) {
            arr.add((JsonElement)new JsonPrimitive(color4f.toString()));
        }
        return arr;
    }
}

