/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.ai.pathing;

import me.jellysquid.mods.lithium.common.ai.pathing.BlockStatePathingCache;
import me.jellysquid.mods.lithium.common.block.BlockCountingSection;
import me.jellysquid.mods.lithium.common.block.BlockStateFlags;
import me.jellysquid.mods.lithium.common.util.Pos;
import me.jellysquid.mods.lithium.common.world.ChunkView;
import me.jellysquid.mods.lithium.common.world.WorldHelper;
import me.jellysquid.mods.lithium.mixin.ai.pathing.PathContextAccessor;
import net.minecraft.class_14;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_4970;
import net.minecraft.class_5539;
import net.minecraft.class_7;
import net.minecraft.class_9316;

public abstract class PathNodeCache {
    private static boolean isChunkSectionDangerousNeighbor(class_2826 section) {
        return section.method_12265().method_19526(state -> PathNodeCache.getNeighborPathNodeType((class_4970.class_4971)state) != class_7.field_7);
    }

    public static class_7 getPathNodeType(class_2680 state) {
        return ((BlockStatePathingCache)state).lithium$getPathNodeType();
    }

    public static class_7 getNeighborPathNodeType(class_4970.class_4971 state) {
        return ((BlockStatePathingCache)state).lithium$getNeighborPathNodeType();
    }

    public static boolean isSectionSafeAsNeighbor(class_2826 section) {
        if (section.method_38292()) {
            return true;
        }
        if (BlockStateFlags.ENABLED) {
            return !((BlockCountingSection)section).lithium$mayContainAny(BlockStateFlags.PATH_NOT_OPEN);
        }
        return !PathNodeCache.isChunkSectionDangerousNeighbor(section);
    }

    public static class_7 getNodeTypeFromNeighbors(class_9316 context, int x, int y, int z, class_7 fallback) {
        class_1941 world = context.method_57621();
        class_2826 section = null;
        if (world instanceof ChunkView) {
            ChunkView chunkView = (ChunkView)world;
            if (WorldHelper.areNeighborsWithinSameChunkSection(x, y, z)) {
                class_2791 chunk;
                if (!world.method_31601(y) && (chunk = chunkView.lithium$getLoadedChunk(Pos.ChunkCoord.fromBlockCoord(x), Pos.ChunkCoord.fromBlockCoord(z))) != null) {
                    section = chunk.method_12006()[Pos.SectionYIndex.fromBlockCoord((class_5539)world, y)];
                }
                if (section == null || PathNodeCache.isSectionSafeAsNeighbor(section)) {
                    return fallback;
                }
            }
        }
        int xStart = x - 1;
        int yStart = y - 1;
        int zStart = z - 1;
        int xEnd = x + 1;
        int yEnd = y + 1;
        int zEnd = z + 1;
        for (int adjX = xStart; adjX <= xEnd; ++adjX) {
            for (int adjY = yStart; adjY <= yEnd; ++adjY) {
                for (int adjZ = zStart; adjZ <= zEnd; ++adjZ) {
                    class_2680 state;
                    if (adjX == x && adjZ == z) continue;
                    if (section != null) {
                        state = section.method_12254(adjX & 0xF, adjY & 0xF, adjZ & 0xF);
                    } else {
                        class_2338.class_2339 pos = ((PathContextAccessor)context).getLastNodePos().method_10103(adjX, adjY, adjZ);
                        state = world.method_8320((class_2338)pos);
                    }
                    if (state.method_26215()) continue;
                    class_7 neighborType = PathNodeCache.getNeighborPathNodeType((class_4970.class_4971)state);
                    if (neighborType == null && (neighborType = class_14.method_59((class_9316)context, (int)(adjX + 1), (int)(adjY + 1), (int)(adjZ + 1), null)) == null) {
                        neighborType = class_7.field_7;
                    }
                    if (neighborType == class_7.field_7) continue;
                    return neighborType;
                }
            }
        }
        return fallback;
    }
}

