/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command;

import io.leangen.geantyref.GenericTypeReflector;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ComponentMessageThrowable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.InvalidCommandSenderException;
import org.incendo.cloud.exception.InvalidSyntaxException;
import org.incendo.cloud.exception.NoPermissionException;
import org.incendo.cloud.exception.handling.ExceptionContext;
import org.incendo.cloud.exception.parsing.ParserException;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.exception.CommandCompletedException;
import xyz.jpenilla.tabtps.common.util.Components;
import xyz.jpenilla.tabtps.common.util.Constants;

public final class ExceptionHandler {
    private final TabTPS tabTPS;

    ExceptionHandler(@NonNull TabTPS tabTPS) {
        this.tabTPS = tabTPS;
    }

    private static void decorateAndSend(@NonNull Commander commander, @NonNull ComponentLike componentLike) {
        commander.sendMessage((Component)Components.ofChildren(new ComponentLike[]{Constants.PREFIX, Component.space(), componentLike}));
    }

    public void apply(@NonNull CommandManager<Commander> manager) {
        manager.exceptionController().registerHandler(CommandExecutionException.class, this::commandExecution);
        manager.exceptionController().registerHandler(NoPermissionException.class, this::noPermission);
        manager.exceptionController().registerHandler(ArgumentParseException.class, this::argumentParsing);
        manager.exceptionController().registerHandler(InvalidCommandSenderException.class, this::invalidSender);
        manager.exceptionController().registerHandler(InvalidSyntaxException.class, this::invalidSyntax);
    }

    private void commandExecution(@NonNull ExceptionContext<Commander, CommandExecutionException> ctx) {
        Throwable cause = ((CommandExecutionException)ctx.exception()).getCause();
        if (cause instanceof CommandCompletedException) {
            Component message = ((CommandCompletedException)cause).componentMessage();
            if (message != null) {
                ((Commander)ctx.context().sender()).sendMessage(message);
            }
            return;
        }
        this.tabTPS.platform().logger().warn("An unexpected error occurred during command execution", cause);
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString().replaceAll("\t", "    ");
        TextComponent.Builder hoverText = Component.text();
        Component throwableMessage = ComponentMessageThrowable.getOrConvertMessage((Throwable)this.tabTPS.platform().asComponentMessageThrowable(cause));
        if (throwableMessage != null) {
            ((TextComponent.Builder)((TextComponent.Builder)hoverText.append(throwableMessage)).append((Component)Component.newline())).append((Component)Component.newline());
        }
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)hoverText.append((Component)Component.text((String)stackTrace))).append((Component)Component.newline())).append((Component)Component.text((String)"    "))).append((Component)Messages.MISC_TEXT_CLICK_TO_COPY.styled((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC, new ComponentLike[0]));
        TextComponent.Builder message = Component.text();
        message.append((Component)Messages.COMMAND_EXCEPTION_COMMAND_EXECUTION.styled((TextColor)NamedTextColor.RED, new ComponentLike[0]));
        if (((Commander)ctx.context().sender()).hasPermission("tabtps.command.hover_stacktrace")) {
            message.hoverEvent((HoverEventSource)hoverText.build());
            message.clickEvent(ClickEvent.copyToClipboard((String)stackTrace));
        }
        ExceptionHandler.decorateAndSend((Commander)ctx.context().sender(), (ComponentLike)message);
    }

    private void noPermission(@NonNull ExceptionContext<Commander, NoPermissionException> ctx) {
        ExceptionHandler.decorateAndSend((Commander)ctx.context().sender(), (ComponentLike)Messages.COMMAND_EXCEPTION_NO_PERMISSION.styled((TextColor)NamedTextColor.RED, new ComponentLike[0]));
    }

    private void argumentParsing(@NonNull ExceptionContext<Commander, ArgumentParseException> ctx) {
        Component message;
        Throwable cause = ((ArgumentParseException)ctx.exception()).getCause();
        if (cause instanceof ParserException) {
            ParserException ex = (ParserException)cause;
            message = Component.translatable((String)(Messages.bundleName() + "/command.caption." + ex.errorCaption().key()), (TextColor)NamedTextColor.GRAY, Arrays.stream(ex.captionVariables()).map(CaptionVariable::value).map(Component::text).collect(Collectors.toList()));
        } else {
            message = Objects.requireNonNull(ComponentMessageThrowable.getOrConvertMessage((Throwable)this.tabTPS.platform().asComponentMessageThrowable(cause))).color((TextColor)NamedTextColor.GRAY);
        }
        ExceptionHandler.decorateAndSend((Commander)ctx.context().sender(), (ComponentLike)Messages.COMMAND_EXCEPTION_INVALID_ARGUMENT.styled((TextColor)NamedTextColor.RED, new ComponentLike[]{message}));
    }

    private void invalidSender(@NonNull ExceptionContext<Commander, InvalidCommandSenderException> ctx) {
        if (((InvalidCommandSenderException)ctx.exception()).requiredSenderTypes().size() > 1) {
            throw new IllegalStateException();
        }
        TranslatableComponent message = Messages.COMMAND_EXCEPTION_INVALID_SENDER_TYPE.styled((TextColor)NamedTextColor.RED, new ComponentLike[]{Component.text((String)GenericTypeReflector.erase((Type)((Type)((InvalidCommandSenderException)ctx.exception()).requiredSenderTypes().iterator().next())).getSimpleName())});
        ExceptionHandler.decorateAndSend((Commander)ctx.context().sender(), (ComponentLike)message);
    }

    private void invalidSyntax(@NonNull ExceptionContext<Commander, InvalidSyntaxException> ctx) {
        TranslatableComponent message = Messages.COMMAND_EXCEPTION_INVALID_SYNTAX.styled((TextColor)NamedTextColor.RED, new ComponentLike[]{Components.highlight((Component)Component.text((String)String.format("/%s", ((InvalidSyntaxException)ctx.exception()).correctSyntax()), (TextColor)NamedTextColor.GRAY), (TextColor)NamedTextColor.WHITE)});
        ExceptionHandler.decorateAndSend((Commander)ctx.context().sender(), (ComponentLike)message);
    }
}

