/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command.commands;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.Comparator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.Command;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.RichDescription;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.Commands;
import xyz.jpenilla.tabtps.common.command.TabTPSCommand;
import xyz.jpenilla.tabtps.common.util.Components;
import xyz.jpenilla.tabtps.common.util.Constants;
import xyz.jpenilla.tabtps.common.util.MemoryUtil;

public final class MemoryCommand
extends TabTPSCommand {
    public MemoryCommand(@NonNull TabTPS tabTPS, @NonNull Commands commands) {
        super(tabTPS, commands);
    }

    @Override
    public void register() {
        this.commands.register((Command.Builder<? extends Commander>)this.commandManager.commandBuilder("memory", new String[]{"mem", "ram"}).permission("tabtps.tps").commandDescription((Description)RichDescription.richDescription((ComponentLike)Messages.COMMAND_MEMORY_DESCRIPTION.plain(new ComponentLike[0]))).handler(this::executeMemory));
    }

    private void executeMemory(@NonNull CommandContext<Commander> ctx) {
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(Component.empty());
        TextComponent header = Components.ofChildren(new ComponentLike[]{Constants.PREFIX, Component.space(), Messages.COMMAND_MEMORY_TEXT_HEADER.styled((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC, new ComponentLike[0])});
        messages.add(header);
        if (!this.tabTPS.configManager().pluginSettings().ignoredMemoryPools().contains("Heap Memory Usage")) {
            messages.add(MemoryUtil.renderBar("Heap Memory Usage", ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), 60));
        }
        if (!this.tabTPS.configManager().pluginSettings().ignoredMemoryPools().contains("Non-Heap Memory Usage")) {
            messages.add(MemoryUtil.renderBar("Non-Heap Memory Usage", ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage(), 60));
        }
        ManagementFactory.getMemoryPoolMXBeans().stream().filter(bean -> bean != null && !this.tabTPS.configManager().pluginSettings().ignoredMemoryPools().contains(bean.getName())).sorted(Comparator.comparing(MemoryPoolMXBean::getName)).map(bean -> MemoryUtil.renderBar(bean.getName(), bean.getUsage(), 60)).forEach(messages::add);
        messages.forEach(arg_0 -> ((Commander)((Commander)ctx.sender())).sendMessage(arg_0));
    }
}

