/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.service;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.incendo.cloud.type.tuple.Pair;
import xyz.jpenilla.tabtps.common.AbstractUser;
import xyz.jpenilla.tabtps.common.TabTPSPlatform;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.config.DisplayConfig;
import xyz.jpenilla.tabtps.common.display.DisplayHandler;

public abstract class UserService<P, U extends User<P>> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final TabTPSPlatform<P, U> platform;
    private final Path userDataDirectory;
    private final Map<UUID, U> userMap = new ConcurrentHashMap<UUID, U>();

    protected UserService(TabTPSPlatform<P, U> platform) {
        this.platform = platform;
        this.userDataDirectory = platform.dataDirectory().resolve("userdata");
    }

    protected abstract UUID uuid(P var1);

    protected abstract U create(P var1);

    private Path userFile(UUID uniqueId) {
        return this.userDataDirectory.resolve(uniqueId + ".json");
    }

    private U loadUser(P base) {
        UUID uniqueId = this.uuid(base);
        Path file = this.userFile(uniqueId);
        U user = this.create(base);
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                User.State deserialized = (User.State)GSON.fromJson((Reader)reader, AbstractUser.StateImpl.class);
                user.state().populate(deserialized);
            }
            catch (Exception ex) {
                this.platform.logger().warn("Failed to load data for user with UUID: " + uniqueId, (Throwable)ex);
            }
        }
        return user;
    }

    private void saveUser(UUID uuid, U user) {
        Path file = this.userFile(uuid);
        if (!Files.exists(file, new LinkOption[0])) {
            this.createEmptyFile(file);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            GSON.toJson((Object)user.state(), (Appendable)writer);
        }
        catch (IOException e) {
            this.platform.logger().warn("Failed to save data for user with UUID: " + uuid, (Throwable)e);
        }
    }

    public final void replacePlayer(P newPlayer) {
        UUID uuid = this.uuid(newPlayer);
        User oldUser = (User)this.userMap.get(uuid);
        if (oldUser == null) {
            throw new IllegalArgumentException("Cannot replace a player who is not logged in!");
        }
        this.shutdownDisplays(oldUser);
        U newUser = this.create(newPlayer);
        newUser.state().populate(oldUser.state());
        this.startEnabledDisplays(newUser);
        this.userMap.put(uuid, newUser);
    }

    public final U user(P base) {
        return (U)this.userMap.computeIfAbsent(this.uuid(base), uuid -> this.loadUser(base));
    }

    public final U user(UUID uniqueId) {
        User user = (User)this.userMap.get(uniqueId);
        if (user == null) {
            throw new IllegalStateException("No user loaded for UUID: " + uniqueId);
        }
        return (U)user;
    }

    public final Map<UUID, U> userStorage() {
        return Collections.unmodifiableMap(this.userMap);
    }

    public final Collection<U> onlineUsers() {
        return Collections.unmodifiableCollection(this.userMap.values());
    }

    protected abstract Collection<P> platformPlayers();

    public final int onlinePlayers() {
        return this.userMap.size();
    }

    public final void reload() {
        this.flush();
        this.platformPlayers().stream().map(this::user).forEach(this::startEnabledDisplays);
    }

    public final void flush() {
        ImmutableSet users = ImmutableSet.copyOf(this.userMap.keySet());
        users.forEach(this::removeUser);
    }

    public final void removeUser(UUID uniqueId) {
        User removed = (User)this.userMap.remove(uniqueId);
        if (removed == null) {
            throw new IllegalStateException("Cannot remove non-existing user " + uniqueId);
        }
        this.shutdownDisplays(removed);
        if (removed.shouldSave()) {
            this.saveUser(uniqueId, removed);
        }
    }

    private void createEmptyFile(Path file) {
        try {
            Files.createDirectories(this.userDataDirectory, new FileAttribute[0]);
            Files.createFile(file, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.platform.logger().warn("Failed to create empty file: " + file, (Throwable)e);
        }
    }

    public final void handleJoin(P platformPlayer) {
        U user = this.user(platformPlayer);
        this.platform.tabTPS().findDisplayConfig((User<?>)user).ifPresent(config -> {
            Stream.of(Pair.of((Object)config.actionBarSettings(), user.actionBar()), Pair.of((Object)config.bossBarSettings(), user.bossBar()), Pair.of((Object)config.tabSettings(), user.tab())).forEach(pair -> {
                if (((DisplayConfig.DisplaySettings)pair.first()).allow() && ((DisplayConfig.DisplaySettings)pair.first()).enableOnLogin()) {
                    ((DisplayHandler)pair.second()).enabled(true);
                }
            });
            this.startEnabledDisplays(user);
        });
    }

    public final void handleQuit(P platformPlayer) {
        this.removeUser(this.uuid(platformPlayer));
    }

    private void shutdownDisplays(U user) {
        user.displays().forEach(DisplayHandler::stopDisplay);
    }

    private void startEnabledDisplays(U user) {
        user.displays().forEach(display -> {
            if (display.enabled()) {
                display.startDisplay();
            }
        });
    }
}

