/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.util;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.function.LongPredicate;
import java.util.stream.LongStream;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.type.tuple.Pair;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.common.util.Components;

public final class TPSUtil {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.00");
    private static final LongPredicate NOT_ZERO = l -> l != 0L;

    private TPSUtil() {
    }

    private static @NonNull String formatDouble(double value) {
        return FORMAT.format(value);
    }

    public static @NonNull Component coloredTps(double tps, @NonNull Theme.Colors colors) {
        TextColor color2;
        TextColor color1;
        if (tps >= 18.5) {
            color1 = colors.goodPerformance();
            color2 = colors.goodPerformanceSecondary();
        } else if (tps > 15.0) {
            color1 = colors.mediumPerformance();
            color2 = colors.mediumPerformanceSecondary();
        } else {
            color1 = colors.lowPerformance();
            color2 = colors.lowPerformanceSecondary();
        }
        return Components.gradient(TPSUtil.formatDouble(tps), color1, color2);
    }

    public static double toMilliseconds(long time) {
        return (double)time * 1.0E-6;
    }

    public static double toMilliseconds(double time) {
        return time * 1.0E-6;
    }

    public static @NonNull Component coloredMspt(double mspt, @NonNull Theme.Colors colors) {
        TextColor color2;
        TextColor color1;
        if (mspt <= 25.0) {
            color1 = colors.goodPerformance();
            color2 = colors.goodPerformanceSecondary();
        } else if (mspt <= 40.0) {
            color1 = colors.mediumPerformance();
            color2 = colors.mediumPerformanceSecondary();
        } else {
            color1 = colors.lowPerformance();
            color2 = colors.lowPerformanceSecondary();
        }
        return Components.gradient(TPSUtil.formatDouble(mspt), color1, color2);
    }

    public static @NonNull List<Component> formatTickTimes(@NonNull List<Pair<String, long[]>> times) {
        BuildableComponent header = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append(new ComponentLike[]{Messages.LABEL_MSPT, Component.text((String)" - ", (TextColor)NamedTextColor.WHITE), Messages.LABEL_AVERAGE, Component.text((String)", ", (TextColor)NamedTextColor.WHITE), Messages.LABEL_MINIMUM, Component.text((String)", ", (TextColor)NamedTextColor.WHITE), Messages.LABEL_MAXIMUM})).hoverEvent((HoverEventSource)Messages.COMMAND_TICKINFO_TEXT_MSPT_HOVER.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0]))).build();
        ArrayList<Component> output = new ArrayList<Component>();
        output.add((Component)header);
        Iterator<Pair<String, long[]>> iterator = times.iterator();
        while (iterator.hasNext()) {
            Pair<String, long[]> pair = iterator.next();
            String branch = iterator.hasNext() ? "\u251c\u2500" : "\u2514\u2500";
            output.add(TPSUtil.formatStatistics(branch, (Component)Component.text((String)((String)pair.first())), (long[])pair.second()));
        }
        return output;
    }

    private static @NonNull Component formatStatistics(@NonNull String branch, @NonNull Component time, long @NonNull [] times) {
        LongSummaryStatistics statistics = LongStream.of(times).filter(NOT_ZERO).summaryStatistics();
        return Components.ofChildren(new ComponentLike[]{Component.space(), Component.text((String)branch, (TextColor)NamedTextColor.WHITE), Component.space(), time.color((TextColor)NamedTextColor.GRAY), Component.text((String)" - ", (TextColor)NamedTextColor.WHITE), TPSUtil.coloredMspt(TPSUtil.toMilliseconds(statistics.getAverage()), Theme.DEFAULT.colorScheme()), Component.text((String)", ", (TextColor)NamedTextColor.WHITE), TPSUtil.coloredMspt(TPSUtil.toMilliseconds(statistics.getMin()), Theme.DEFAULT.colorScheme()), Component.text((String)", ", (TextColor)NamedTextColor.WHITE), TPSUtil.coloredMspt(TPSUtil.toMilliseconds(statistics.getMax()), Theme.DEFAULT.colorScheme())});
    }

    public static double average(long @NonNull [] longs) {
        long i = 0L;
        for (long l : longs) {
            i += l;
        }
        return (double)i / (double)longs.length;
    }
}

