/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.util;

import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class UpdateChecker {
    private static final JsonParser parser = new JsonParser();

    private UpdateChecker() {
    }

    public static @NonNull List<String> checkVersion(@NonNull String version) {
        JsonArray result;
        try {
            result = parser.parse((Reader)new InputStreamReader(new URL("https://api.github.com/repos/jpenilla/TabTPS/releases").openStream(), Charsets.UTF_8)).getAsJsonArray();
        }
        catch (IOException exception) {
            return Collections.singletonList("Failed to look for updates: " + exception.getMessage());
        }
        LinkedHashMap versionMap = new LinkedHashMap();
        result.forEach(element -> versionMap.put(element.getAsJsonObject().get("tag_name").getAsString(), element.getAsJsonObject().get("html_url").getAsString()));
        LinkedList versionList = new LinkedList(versionMap.keySet());
        String currentVersion = "v" + version;
        if (((String)versionList.get(0)).equals(currentVersion)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (currentVersion.contains("SNAPSHOT")) {
            list.add("This server is running a development build of TabTPS! (" + currentVersion + ")");
            list.add("The latest official release is " + (String)versionList.get(0));
            return list;
        }
        int versionsBehind = versionList.indexOf(currentVersion);
        list.add("There is an update available for TabTPS!");
        list.add("This server is running version " + currentVersion + ", which is " + (versionsBehind == -1 ? "UNKNOWN" : Integer.valueOf(versionsBehind)) + " versions outdated.");
        list.add("Download the latest version, " + (String)versionList.get(0) + " from GitHub at the link below:");
        list.add((String)versionMap.get(versionList.get(0)));
        return list;
    }
}

