/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import dev.kosmx.playerAnim.core.data.AnimationBinary;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EmoteDataPacket
extends AbstractNetworkPacket {
    public int tick = 0;

    @Override
    public void write(ByteBuffer buf, NetData config) {
        int version = this.calculateVersion(config);
        assert (config.emoteData != null);
        buf.putInt(config.tick);
        AnimationBinary.write((KeyframeAnimation)config.emoteData, (ByteBuffer)buf, (int)version);
    }

    @Override
    public boolean read(ByteBuffer buf, NetData config, int version) throws IOException {
        try {
            config.tick = buf.getInt();
            KeyframeAnimation animation = AnimationBinary.read((ByteBuffer)buf, (int)version);
            config.valid = (Boolean)animation.extraData.get("valid");
            config.emoteBuilder = animation.mutableCopy();
            config.wasEmoteData = true;
            return true;
        }
        catch (IOException | RuntimeException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public byte getID() {
        return 0;
    }

    @Override
    public byte getVer() {
        return (byte)AnimationBinary.getCurrentVersion();
    }

    protected int calculateVersion(NetData config) {
        return Math.min(config.versions.get(this.getID()).byteValue(), this.getVer());
    }

    @Override
    public boolean doWrite(NetData data) {
        return data.emoteData != null && data.stopEmoteID == null;
    }

    @Override
    public int calculateSize(NetData config) {
        if (config.emoteData == null) {
            return 0;
        }
        return AnimationBinary.calculateSize((KeyframeAnimation)config.emoteData, (int)this.calculateVersion(config)) + 4;
    }
}

