/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.fabric.network;

import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.arch.network.client.ClientNetwork;
import io.github.kosmx.emotes.executor.EmoteInstance;
import java.io.IOException;
import java.util.logging.Level;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;

public class ClientNetworkInstance {
    public static void init() {
        ClientConfigurationNetworking.registerGlobalReceiver(NetworkPlatformTools.EMOTE_CHANNEL_ID, (buf, context) -> {
            try {
                ClientNetwork.INSTANCE.receiveConfigMessage(buf.bytes(), arg_0 -> ((PacketSender)context.responseSender()).sendPacket(arg_0));
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        });
        ClientConfigurationNetworking.registerGlobalReceiver(NetworkPlatformTools.STREAM_CHANNEL_ID, (buf, context) -> {
            try {
                ClientNetwork.INSTANCE.receiveStreamMessage(buf.bytes(), arg_0 -> ((PacketSender)context.responseSender()).sendPacket(arg_0));
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        });
        C2SPlayChannelEvents.REGISTER.register((handler, sender, minecraft, channels) -> {
            if (channels.contains(NetworkPlatformTools.EMOTE_CHANNEL_ID.comp_2242())) {
                ClientNetwork.INSTANCE.configureOnPlay(arg_0 -> ((PacketSender)sender).sendPacket(arg_0));
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ClientNetwork.INSTANCE.disconnect());
        ClientPlayNetworking.registerGlobalReceiver(NetworkPlatformTools.EMOTE_CHANNEL_ID, (buf, context) -> ClientNetwork.INSTANCE.receiveMessage(buf.unwrapBytes()));
        ClientPlayNetworking.registerGlobalReceiver(NetworkPlatformTools.STREAM_CHANNEL_ID, (buf, context) -> {
            try {
                ClientNetwork.INSTANCE.receiveStreamMessage(buf.bytes(), null);
            }
            catch (IOException e) {
                EmoteInstance.instance.getLogger().log(Level.WARNING, e.getMessage(), e);
            }
        });
    }
}

