/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.network;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.impl.event.EventResult;
import dev.kosmx.playerAnim.core.util.Pair;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.api.events.client.ClientEmoteAPI;
import io.github.kosmx.emotes.api.events.client.ClientEmoteEvents;
import io.github.kosmx.emotes.api.proxy.INetworkInstance;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.executor.emotePlayer.IEmotePlayerEntity;
import io.github.kosmx.emotes.inline.TmpGetters;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.mixinFunctions.IPlayerEntity;
import io.github.kosmx.emotes.main.network.ClientPacketManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2561;

public class ClientEmotePlay
extends ClientEmoteAPI {
    private static final HashMap<UUID, QueueEntry> queue = new HashMap();

    public static void clientStartLocalEmote(EmoteHolder emoteHolder) {
        ClientEmotePlay.clientStartLocalEmote(emoteHolder.getEmote());
    }

    public static boolean clientStartLocalEmote(KeyframeAnimation emote) {
        return ClientEmotePlay.clientStartLocalEmote(emote, 0);
    }

    public static boolean clientStartLocalEmote(KeyframeAnimation emote, int tick) {
        IPlayerEntity player = TmpGetters.getClientMethods().getMainPlayer();
        if (player.emotecraft$isForcedEmote()) {
            return false;
        }
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
        packetBuilder.configureToStreamEmote(emote, player.emotes_getUUID());
        packetBuilder.configureEmoteTick(tick);
        ClientPacketManager.send(packetBuilder, null);
        ((ClientEmoteEvents.EmotePlayEvent)ClientEmoteEvents.EMOTE_PLAY.invoker()).onEmotePlay(emote, player.emotes_getUUID());
        TmpGetters.getClientMethods().getMainPlayer().emotecraft$playEmote(emote, tick, false);
        return true;
    }

    public static void clientRepeatLocalEmote(KeyframeAnimation emote, int tick, UUID target) {
        EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
        packetBuilder.configureToStreamEmote(emote, TmpGetters.getClientMethods().getMainPlayer().emotes_getUUID()).configureEmoteTick(tick);
        ClientPacketManager.send(packetBuilder, target);
    }

    public static boolean clientStopLocalEmote() {
        if (TmpGetters.getClientMethods().getMainPlayer().isPlayingEmote()) {
            return ClientEmotePlay.clientStopLocalEmote(TmpGetters.getClientMethods().getMainPlayer().emotecraft$getEmote().getData());
        }
        return false;
    }

    public static boolean isForcedEmote() {
        IPlayerEntity player = TmpGetters.getClientMethods().getMainPlayer();
        return player.emotecraft$isForcedEmote();
    }

    public static boolean clientStopLocalEmote(KeyframeAnimation emoteData) {
        if (emoteData != null && !TmpGetters.getClientMethods().getMainPlayer().emotecraft$isForcedEmote()) {
            EmotePacket.Builder packetBuilder = new EmotePacket.Builder();
            packetBuilder.configureToSendStop(emoteData.getUuid(), TmpGetters.getClientMethods().getMainPlayer().emotes_getUUID());
            ClientPacketManager.send(packetBuilder, null);
            TmpGetters.getClientMethods().getMainPlayer().stopEmote();
            ((ClientEmoteEvents.LocalEmoteStopEvent)ClientEmoteEvents.LOCAL_EMOTE_STOP.invoker()).onEmoteStop();
            return true;
        }
        return false;
    }

    static void executeMessage(NetData data, INetworkInstance networkInstance) throws NullPointerException {
        EmoteInstance.instance.getLogger().log(Level.FINEST, "[emotes client] Received message: " + String.valueOf(data));
        if (data.purpose == null && EmoteInstance.config.showDebug.get().booleanValue()) {
            EmoteInstance.instance.getLogger().log(Level.INFO, "Packet execution is not possible without a purpose");
        }
        switch (Objects.requireNonNull(data.purpose)) {
            case STREAM: {
                assert (data.emoteData != null);
                if (!data.valid && (((ClientConfig)EmoteInstance.config).alwaysValidate.get().booleanValue() || !networkInstance.safeProxy())) break;
                ClientEmotePlay.receivePlayPacket(data.emoteData, data.player, data.tick, data.isForced);
                break;
            }
            case STOP: {
                IEmotePlayerEntity player = PlatformTools.getPlayerFromUUID(data.player);
                assert (data.stopEmoteID != null);
                if (player != null) {
                    ((ClientEmoteEvents.EmoteStopEvent)ClientEmoteEvents.EMOTE_STOP.invoker()).onEmoteStop(data.stopEmoteID, player.emotes_getUUID());
                    player.stopEmote(data.stopEmoteID);
                    if (!player.isMainPlayer() || data.isForced) break;
                    TmpGetters.getClientMethods().sendChatMessage((class_2561)class_2561.method_43471((String)"emotecraft.blockedEmote"));
                    break;
                }
                queue.remove(data.player);
                break;
            }
            case CONFIG: {
                networkInstance.setVersions(Objects.requireNonNull(data.versions));
                break;
            }
            case FILE: {
                EmoteHolder.addEmoteToList((KeyframeAnimation)data.emoteData).fromInstance = networkInstance;
            }
            case UNKNOWN: {
                if (!EmoteInstance.config.showDebug.get().booleanValue()) break;
                EmoteInstance.instance.getLogger().log(Level.INFO, "Packet execution is not possible unknown purpose");
            }
        }
    }

    static void receivePlayPacket(KeyframeAnimation emoteData, UUID player, int tick, boolean isForced) {
        IEmotePlayerEntity playerEntity = PlatformTools.getPlayerFromUUID(player);
        if (ClientEmotePlay.isEmoteAllowed(emoteData, player)) {
            EventResult result = ((ClientEmoteEvents.EmoteVerifier)ClientEmoteEvents.EMOTE_VERIFICATION.invoker()).verify(emoteData, player);
            if (result == EventResult.FAIL) {
                return;
            }
            if (playerEntity != null) {
                ((ClientEmoteEvents.EmotePlayEvent)ClientEmoteEvents.EMOTE_PLAY.invoker()).onEmotePlay(emoteData, player);
                playerEntity.emotecraft$playEmote(emoteData, tick, isForced);
            } else {
                ClientEmotePlay.addToQueue(new QueueEntry(emoteData, tick, TmpGetters.getClientMethods().getCurrentTick()), player);
            }
        }
    }

    public static boolean isEmoteAllowed(KeyframeAnimation emoteData, UUID player) {
        return !(((ClientConfig)EmoteInstance.config).enablePlayerSafety.get() == false && TmpGetters.getClientMethods().isPlayerBlocked(player) || emoteData.nsfw && ((ClientConfig)EmoteInstance.config).enableNSFW.get() == false);
    }

    static void addToQueue(QueueEntry entry, UUID player) {
        queue.put(player, entry);
    }

    @Nullable
    public static Pair<KeyframeAnimation, Integer> getEmoteForUUID(UUID uuid) {
        if (queue.containsKey(uuid)) {
            QueueEntry entry = queue.get(uuid);
            KeyframeAnimation emoteData = entry.emoteData;
            int tick = entry.beginTick - entry.receivedTick + TmpGetters.getClientMethods().getCurrentTick();
            queue.remove(uuid);
            if (!emoteData.isPlayingAt(tick)) {
                return null;
            }
            return new Pair((Object)emoteData, (Object)tick);
        }
        return null;
    }

    public static void checkQueue() {
        int currentTick = TmpGetters.getClientMethods().getCurrentTick();
        queue.forEach((uuid, entry) -> {
            if (!entry.emoteData.isPlayingAt(entry.beginTick + currentTick) && entry.beginTick + currentTick > 0 || TmpGetters.getClientMethods().getCurrentTick() - entry.receivedTick > 24000) {
                queue.remove(uuid);
            }
        });
    }

    public static void init() {
        ClientEmoteAPI.INSTANCE = new ClientEmotePlay();
    }

    @Override
    protected boolean playEmoteImpl(KeyframeAnimation animation, int tick) {
        if (animation != null) {
            return ClientEmotePlay.clientStartLocalEmote(animation, tick);
        }
        return ClientEmotePlay.clientStopLocalEmote();
    }

    @Override
    protected Collection<KeyframeAnimation> clientEmoteListImpl() {
        return EmoteHolder.list.values().stream().map(EmoteHolder::getEmote).collect(Collectors.toList());
    }

    static class QueueEntry {
        final KeyframeAnimation emoteData;
        final int beginTick;
        final int receivedTick;

        QueueEntry(KeyframeAnimation emoteData, int begin, int received) {
            this.emoteData = emoteData;
            this.beginTick = begin;
            this.receivedTick = received;
        }
    }
}

