/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1079;
import net.minecraft.class_161;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3495;
import net.minecraft.class_3542;
import net.minecraft.class_4917;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7475;
import net.minecraft.class_7788;
import net.minecraft.class_8074;
import net.minecraft.class_8076;
import net.minecraft.class_8779;
import net.minecraft.class_8786;
import net.minecraft.class_8790;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.slf4j.Logger;
import pers.solid.brrp.v1.JsonSerializers;
import pers.solid.brrp.v1.api.JsonSerializable;
import pers.solid.brrp.v1.api.LanguageProvider;
import pers.solid.brrp.v1.impl.BRRPBlockLootTableGenerator;
import pers.solid.brrp.v1.impl.RuntimeResourcePackImpl;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.tag.IdentifiedTagBuilder;

public interface RuntimeResourcePack
extends class_3262 {
    public static final Path DEFAULT_OUTPUT = Paths.get("rrp.debug", new String[0]);
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().registerTypeHierarchyAdapter(class_52.class, JsonSerializers.forCodec(class_52.field_50021)).registerTypeHierarchyAdapter(class_161.class, JsonSerializers.forCodec(class_161.field_47179)).registerTypeHierarchyAdapter(class_7475.class, JsonSerializers.forCodec(class_7475.field_39269)).registerTypeHierarchyAdapter(class_1860.class, JsonSerializers.forCodec(class_1860.field_47319)).registerTypeHierarchyAdapter(JsonSerializable.class, JsonSerializable.SERIALIZER).registerTypeHierarchyAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeHierarchyAdapter(class_3542.class, JsonSerializers.STRING_IDENTIFIABLE).registerTypeHierarchyAdapter(Vector3f.class, JsonSerializers.VECTOR_3F).registerTypeHierarchyAdapter(Either.class, JsonSerializers.EITHER).setPrettyPrinting().create();
    public static final Logger LOGGER = LogUtils.getLogger();

    @Contract(value="_ -> new")
    public static RuntimeResourcePack create(class_2960 id) {
        return new RuntimeResourcePackImpl(id);
    }

    @Contract(value="_, _ -> new")
    public static RuntimeResourcePack create(class_2960 id, @NotNull class_7225.class_7874 registryLookup) {
        return new RuntimeResourcePackImpl(id, registryLookup);
    }

    public static byte[] serialize(Object object, @NotNull Gson gson) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        gson.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream.toByteArray();
    }

    public static byte[] defaultSerialize(Object object) {
        return RuntimeResourcePack.serialize(object, GSON);
    }

    default public byte[] serialize(Object object) {
        return RuntimeResourcePack.defaultSerialize(object);
    }

    @Contract(pure=true)
    public int getPackVersion();

    @Contract(mutates="this")
    public void setPackVersion(int var1);

    @Contract(mutates="this")
    public void setAllowsDuplicateResource(boolean var1);

    @ApiStatus.Experimental
    @Contract(mutates="this")
    public void addRecoloredImage(class_2960 var1, InputStream var2, IntUnaryOperator var3);

    @Contract(mutates="this")
    public byte[] addLang(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addLang(class_2960 identifier, LanguageProvider lang) {
        return this.addLang(identifier, this.serialize(lang.content()));
    }

    @Contract(mutates="this")
    public byte[] addLootTable(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addLootTable(class_2960 identifier, class_52 lootTable) {
        return this.addLootTable(identifier, this.serialize(lootTable));
    }

    @Contract(mutates="this")
    default public byte[] addLootTable(class_2960 identifier, class_52.class_53 lootTable) {
        return this.addLootTable(identifier, lootTable.method_338());
    }

    @Contract(mutates="this")
    public Future<byte[]> addAsyncResource(class_3264 var1, class_2960 var2, FailableFunction<class_2960, byte[], Exception> var3);

    @Contract(mutates="this")
    public void addLazyResource(class_3264 var1, class_2960 var2, BiFunction<RuntimeResourcePack, class_2960, byte[]> var3);

    @Contract(mutates="this")
    public byte[] addResource(class_3264 var1, class_2960 var2, byte[] var3);

    @Contract(mutates="this")
    public Future<byte[]> addAsyncRootResource(String var1, FailableFunction<String, byte[], Exception> var2);

    @Contract(mutates="this")
    public void addLazyRootResource(String var1, BiFunction<RuntimeResourcePack, String, byte[]> var2);

    @Contract(mutates="this")
    public byte[] addRootResource(String var1, byte[] var2);

    @Contract(mutates="this")
    public byte[] addAsset(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    public byte[] addData(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    public byte[] addBlockState(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addBlockState(class_2960 id, @NotNull class_4917 state) {
        return this.addBlockState(id, this.serialize(state.get()));
    }

    @Contract(mutates="this")
    public byte[] addTexture(class_2960 var1, BufferedImage var2);

    @Contract(mutates="this")
    public byte[] addTag(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addTag(class_2960 fullId, class_3495 tagBuilder) {
        return this.addTag(fullId, this.serialize(new class_7475(tagBuilder.method_26782(), false)));
    }

    @Contract(mutates="this")
    public <T> byte[] addTag(class_6862<T> var1, class_3495 var2);

    @Contract(mutates="this")
    default public <T> byte[] addTag(IdentifiedTagBuilder<T> identifiedTagBuilder) {
        return this.addTag(class_6862.method_40092((class_5321)identifiedTagBuilder.registry.method_30517(), (class_2960)identifiedTagBuilder.identifier), identifiedTagBuilder);
    }

    @Contract(mutates="this")
    public byte[] addAnimation(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    @Environment(value=EnvType.CLIENT)
    default public byte[] addAnimation(class_2960 id, class_1079 animation) {
        return this.addAnimation(id, this.serialize(animation));
    }

    @Contract(mutates="this")
    public byte[] addRecipe(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addRecipe(class_2960 id, class_1860<?> recipe) {
        return this.addRecipe(id, this.serialize(recipe));
    }

    @Contract(mutates="this")
    default public byte[] addRecipe(@NotNull class_8786<?> recipeEntry) {
        return this.addRecipe(recipeEntry.comp_1932(), recipeEntry.comp_1933());
    }

    default public class_8790 getRecipeExporter() {
        return new class_8790(){

            public void method_53819(class_2960 recipeId, class_1860<?> recipe, @Nullable class_8779 advancement) {
                RuntimeResourcePack.this.addRecipe(recipeId, recipe);
                if (advancement != null) {
                    RuntimeResourcePack.this.addAdvancement(advancement);
                }
            }

            public class_161.class_162 method_53818() {
                return class_161.class_162.method_51698().method_701(new class_8779(class_5797.field_39377, null));
            }
        };
    }

    @Contract(mutates="this")
    default public void addRecipeAndAdvancement(class_2960 recipeId, @NotNull class_5797 recipeJsonBuilder) {
        recipeJsonBuilder.method_17972(this.getRecipeExporter(), recipeId);
    }

    @Contract(mutates="this")
    default public void addRecipeAndAdvancement(class_2960 recipeId, @NotNull class_8074 recipeJsonBuilder) {
        recipeJsonBuilder.method_48537(this.getRecipeExporter(), recipeId);
    }

    @Contract(mutates="this")
    default public void addRecipeAndAdvancement(class_2960 recipeId, @NotNull class_8076 recipeJsonBuilder) {
        recipeJsonBuilder.method_48542(this.getRecipeExporter(), recipeId);
    }

    @Contract(mutates="this")
    default public byte[] addModel(class_2960 id, ModelJsonBuilder model) {
        return this.addModel(id, this.serialize(model));
    }

    @Contract(mutates="this")
    public byte[] addModel(class_2960 var1, byte[] var2);

    @Contract(mutates="this")
    default public byte[] addAdvancement(class_2960 id, class_161.class_162 advancement) {
        return this.addAdvancement(id, this.serialize(advancement.method_695(id).comp_1920()));
    }

    default public byte[] addAdvancement(class_2960 id, class_161 advancement) {
        return this.addAdvancement(id, this.serialize(advancement));
    }

    default public byte[] addAdvancement(@NotNull class_8779 advancementEntry) {
        return this.addAdvancement(advancementEntry.comp_1919(), advancementEntry.comp_1920());
    }

    @Contract(mutates="this")
    public byte[] addAdvancement(class_2960 var1, byte[] var2);

    public Future<?> async(Consumer<RuntimeResourcePack> var1);

    default public void dumpToDefaultPath() {
        this.dump(DEFAULT_OUTPUT);
    }

    @Contract(mutates="param3")
    public void dumpInPath(Path var1, @Nullable class_3264 var2, int @Nullable [] var3);

    public void load(Path var1) throws IOException;

    public void load(ZipInputStream var1) throws IOException;

    default public void dump(@NotNull Path path) {
        String id = this.method_14409();
        this.dumpInPath(path.resolve(id.replace(':', '/')), null, null);
    }

    public void dump(ZipOutputStream var1) throws IOException;

    @Contract(pure=true)
    default public boolean hasRegenerationCallback() {
        return this.hasSidedRegenerationCallback(class_3264.field_14188) || this.hasSidedRegenerationCallback(class_3264.field_14190) || this.hasSidedRegenerationCallback(null);
    }

    @Contract(pure=true)
    public boolean hasSidedRegenerationCallback(@Nullable class_3264 var1);

    @Contract(mutates="this")
    public void setRegenerationCallback(FailableRunnable<InterruptedException> var1);

    @Contract(mutates="this")
    public void setSidedRegenerationCallback(@NotNull class_3264 var1, FailableRunnable<InterruptedException> var2);

    public void regenerate() throws InterruptedException;

    public void regenerateSided(@NotNull class_3264 var1) throws InterruptedException;

    @Contract(pure=true)
    public String method_14409();

    @Contract(mutates="this")
    public void clearResources(class_3264 var1);

    @Contract(mutates="this")
    public void clearResources();

    @Contract(mutates="this")
    public void clearRootResources();

    @Contract(pure=true)
    default public class_2561 getDisplayName() {
        return class_2561.method_43469((String)"brrp.pack.defaultName", (Object[])new Object[]{this.method_14409()});
    }

    @Contract(mutates="this")
    public void setDisplayName(class_2561 var1);

    @Contract(pure=true)
    @Nullable
    public class_2561 getDescription();

    @Contract(mutates="this")
    public void setDescription(class_2561 var1);

    @Contract(pure=true)
    public int numberOfClientResources();

    @Contract(pure=true)
    public int numberOfServerData();

    @Contract(pure=true)
    public int numberOfRootResources();

    @Contract(pure=true)
    public class_7225.class_7874 getRegistryLookup();

    @Contract(pure=true)
    default public class_7788 getBlockLootTableGenerator() {
        return new BRRPBlockLootTableGenerator(this.getRegistryLookup());
    }
}

