/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_3981;
import net.minecraft.class_4917;
import net.minecraft.class_4945;
import net.minecraft.class_52;
import net.minecraft.class_5797;
import net.minecraft.class_7788;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.BRRPUtils;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.ItemResourceGenerator;
import pers.solid.brrp.v1.generator.TextureRegistry;
import pers.solid.brrp.v1.impl.BRRPBlockLootTableGenerator;
import pers.solid.brrp.v1.model.ModelJsonBuilder;

public interface BlockResourceGenerator
extends ItemResourceGenerator {
    @Contract(pure=true)
    @Nullable
    default public class_2248 getBaseBlock() {
        return null;
    }

    @Contract(pure=true)
    default public class_2960 getBlockId() {
        return class_7923.field_41175.method_10221((Object)((class_2248)this));
    }

    @Override
    @Contract(pure=true)
    default public class_2960 getItemId() {
        BlockResourceGenerator blockResourceGenerator = this;
        if (blockResourceGenerator instanceof class_2248) {
            class_2248 block = (class_2248)blockResourceGenerator;
            class_1792 item = block.method_8389();
            if (item == class_1802.field_8162) {
                if (class_1747.field_8003.containsKey(block)) {
                    return class_7923.field_41178.method_10221((Object)((class_1792)class_1747.field_8003.get(block)));
                }
                return null;
            }
            return class_7923.field_41178.method_10221((Object)item);
        }
        return null;
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    default public class_2960 getBlockModelId() {
        return this.getBlockId().brrp_prefixed("block/");
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    @NotNull
    default public class_2960 getTextureId(@NotNull class_4945 textureKey) {
        BlockResourceGenerator blockResourceGenerator = this;
        if (blockResourceGenerator instanceof class_2248) {
            class_2248 thisBlock = (class_2248)blockResourceGenerator;
            class_2960 texture = TextureRegistry.getTexture(thisBlock, textureKey);
            if (texture != null) {
                return texture;
            }
            @Nullable class_2248 baseBlock = this.getBaseBlock();
            if (baseBlock != null) {
                return BRRPUtils.getTextureId(baseBlock, textureKey);
            }
        }
        return this.getBlockId().brrp_prefixed("block/");
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public class_4917 getBlockStates() {
        return null;
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeBlockStates(RuntimeResourcePack pack) {
        class_4917 blockStates = this.getBlockStates();
        if (blockStates != null) {
            pack.addBlockState(this.getBlockId(), blockStates);
        }
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ModelJsonBuilder getBlockModel() {
        return null;
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeBlockModel(RuntimeResourcePack pack) {
        @Nullable ModelJsonBuilder model = this.getBlockModel();
        if (model != null) {
            pack.addModel(this.getBlockModelId(), model);
        }
    }

    @Override
    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public class_2960 getItemModelId() {
        class_2960 itemId = this.getItemId();
        if (itemId == null) {
            return null;
        }
        return itemId.brrp_prefixed("item/");
    }

    @Override
    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ModelJsonBuilder getItemModel() {
        return ModelJsonBuilder.create(this.getBlockModelId());
    }

    @Override
    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeItemModel(RuntimeResourcePack pack) {
        ModelJsonBuilder model;
        class_2960 itemModelId = this.getItemModelId();
        if (itemModelId != null && (model = this.getItemModel()) != null) {
            pack.addModel(itemModelId, model);
        }
    }

    @Override
    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeAssets(RuntimeResourcePack pack) {
        this.writeBlockStates(pack);
        this.writeBlockModel(pack);
        this.writeItemModel(pack);
    }

    @Contract(pure=true)
    @ApiStatus.NonExtendable
    default public class_2960 getLootTableId() {
        return this.getBlockId().brrp_prefixed("blocks/");
    }

    @Deprecated(forRemoval=true)
    @Contract(pure=true)
    default public class_52.class_53 getLootTable() {
        return new BRRPBlockLootTableGenerator(null).method_45976((class_1935)this);
    }

    @ApiStatus.AvailableSince(value="1.0.4")
    @Contract(pure=true)
    default public class_52.class_53 getLootTable(class_7788 blockLootTableGenerator) {
        try {
            Method method = this.getClass().getMethod("getLootTable", new Class[0]);
            if (method.getDeclaringClass() != BlockResourceGenerator.class) {
                method.setAccessible(true);
                RuntimeResourcePack.LOGGER.warn("Runtime Resource Pack: Using deprecated 'getLootTable()' method for object {}!", (Object)this);
                return (class_52.class_53)method.invoke((Object)this, new Object[0]);
            }
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            RuntimeResourcePack.LOGGER.warn("Runtime Resource Pack: Cannot find deprecated method 'getLootTable' for {}:", (Object)this, (Object)e);
        }
        return blockLootTableGenerator.method_45976((class_1935)this);
    }

    @Contract(mutates="param1")
    default public void writeLootTable(RuntimeResourcePack pack) {
        class_2960 lootTableId = this.getLootTableId();
        if (lootTableId.equals((Object)class_39.field_844.method_29177())) {
            return;
        }
        class_52.class_53 lootTable = this.getLootTable(pack.getBlockLootTableGenerator());
        if (lootTable != null) {
            pack.addLootTable(lootTableId, lootTable);
        }
    }

    @Contract(pure=true)
    default public class_3981 getStonecuttingRecipe() {
        return null;
    }

    @Contract(pure=true)
    default public boolean shouldWriteStonecuttingRecipe() {
        return false;
    }

    @Override
    default public void writeRecipes(RuntimeResourcePack pack) {
        class_3981 stonecuttingRecipe;
        ItemResourceGenerator.super.writeRecipes(pack);
        if (this.shouldWriteStonecuttingRecipe() && (stonecuttingRecipe = this.getStonecuttingRecipe()) != null) {
            pack.addRecipeAndAdvancement(this.getStonecuttingRecipeId(), (class_5797)stonecuttingRecipe);
        }
    }

    @NotNull
    @Contract(pure=true)
    default public class_2960 getStonecuttingRecipeId() {
        return this.getRecipeId().brrp_suffixed("_from_stonecutting");
    }

    @Override
    default public void writeData(RuntimeResourcePack pack) {
        this.writeLootTable(pack);
        this.writeRecipes(pack);
    }
}

