/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class TextureRegistry {
    private static final Object2ObjectMap<@NotNull class_2248, class_4944> TEXTURE_MAPS = new Object2ObjectOpenHashMap();

    private TextureRegistry() {
    }

    public static void register(class_2248 block, class_2960 texture) {
        TextureRegistry.register(block, class_4945.field_23010, texture);
    }

    public static void register(class_2248 block, class_4945 textureKey, class_2960 texture) {
        ((class_4944)TEXTURE_MAPS.computeIfAbsent((Object)block, b -> new class_4944())).method_25868(textureKey, texture);
    }

    public static void registerSuffixed(class_2248 block, class_4945 textureKey, String suffix) {
        TextureRegistry.register(block, textureKey, class_7923.field_41175.method_10221((Object)block).brrp_prefix_and_suffixed("block/", suffix));
    }

    public static void registerWithName(class_2248 block, class_4945 textureKey, String path) {
        class_2960 id = class_7923.field_41175.method_10221((Object)block);
        TextureRegistry.register(block, textureKey, class_2960.method_60655((String)id.method_12836(), (String)("block/" + path)));
    }

    @Nullable
    public static class_2960 getTexture(@NotNull class_2248 block, @NotNull class_4945 textureKey) {
        @Nullable class_4944 textureMap = (class_4944)TEXTURE_MAPS.getOrDefault((Object)block, null);
        if (textureMap == null) {
            return null;
        }
        try {
            return textureMap.method_25867(textureKey);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    @Nullable
    public static class_2960 getTexture(@NotNull class_2248 block) {
        return TextureRegistry.getTexture(block, class_4945.field_23010);
    }

    public static @UnmodifiableView Map<class_2248, class_4944> getTextureMaps() {
        return Collections.unmodifiableMap(TEXTURE_MAPS);
    }
}

