/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.gui;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3542;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import org.apache.commons.io.file.PathUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.gui.RRPConfigScreen;

@Environment(value=EnvType.CLIENT)
public class DumpScreen
extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"BRRP/DumpScreen");
    private final class_437 parent;
    private final RuntimeResourcePack pack;
    private final int[] dumpStat = new int[3];
    private class_5676<DumpType> dumpTypeButton;
    @NotNull
    private DumpType dumpType = DumpType.ALL;
    private class_7842 dumpPathText;
    private class_342 dumpPathTextField;
    private Path dumpPath;
    private String dumpPathString;
    private InvalidPathException invalidPathException;
    private class_7940 dumpPathPreviewText;
    private class_7842 summaryText;
    private class_7842 dumpProgressText;
    private class_4185 dumpButton;
    private class_4185 interruptButton;
    private class_4185 backButton;
    private Thread dumpThread;

    protected DumpScreen(class_437 parent, @NotNull RuntimeResourcePack pack) {
        super((class_2561)class_2561.method_43469((String)"brrp.dumpScreen.title", (Object[])new Object[]{pack.getDisplayName()}));
        this.parent = parent;
        this.pack = pack;
        this.dumpPath = RuntimeResourcePack.DEFAULT_OUTPUT.resolve(pack.method_14409().replace(':', '/'));
        this.dumpPathString = this.dumpPath.toString();
    }

    protected void method_25426() {
        super.method_25426();
        this.dumpTypeButton = new class_5676.class_5677(dumpType -> class_2561.method_43471((String)("brrp.dumpScreen.dumpType." + dumpType.method_15434()))).method_32624((Object[])DumpType.values()).method_32619((Object)this.dumpType).method_32618(value -> class_7919.method_47407((class_2561)class_2561.method_43471((String)("brrp.dumpScreen.dumpType.tooltip." + value.method_15434())))).method_32617(this.field_22789 / 2 - 100, 30, 200, 20, (class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dumpType"), (button, value) -> {
            this.dumpType = value;
        });
        this.method_37063((class_364)this.dumpTypeButton);
        this.dumpPathText = new class_7842(this.field_22789 / 2 - 100, 65, 200, 20, (class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dumpPath.title"), this.field_22793).method_46438(0xCCCCCC).method_48597();
        this.method_37063((class_364)this.dumpPathText);
        this.dumpPathTextField = new class_342(this.field_22793, 20, 85, this.field_22789 - 40, 20, (class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dumpPath.message"));
        this.dumpPathTextField.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dumpPath.tooltip")));
        this.dumpPathTextField.method_1880(64);
        this.dumpPathTextField.method_1863(s -> {
            this.dumpPathString = s;
            try {
                this.dumpPath = Path.of(s, new String[0]);
                this.invalidPathException = null;
                this.dumpPathPreviewText.method_25355((class_2561)class_2561.method_43469((String)"brrp.dumpScreen.dumpToPath", (Object[])new Object[]{this.dumpPath.toAbsolutePath().toString()}).method_27692(class_124.field_1060));
            }
            catch (InvalidPathException exception) {
                this.invalidPathException = exception;
                this.dumpPathPreviewText.method_25355((class_2561)class_2561.method_43469((String)"brrp.dumpScreen.dumpInvalidPath", (Object[])new Object[]{this.invalidPathException.getMessage()}).method_27692(class_124.field_1061));
                this.dumpButton.field_22763 = false;
            }
            this.dumpPathPreviewText.method_46421(this.field_22789 / 2 - this.dumpPathPreviewText.method_25368() / 2);
            this.dumpPathTextField.method_47400(class_7919.method_47408((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dumpPath.tooltip"), (class_2561)this.dumpPathPreviewText.method_25369().method_27661().method_10852(class_5244.field_33849).method_10852((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dumpPath.tooltip"))));
        });
        this.method_37063((class_364)this.dumpPathTextField);
        this.dumpPathPreviewText = new class_7940(20, 120, class_5244.field_39003, this.field_22793).method_48984(this.field_22789 - 40).method_48981(true);
        this.dumpPathTextField.method_1852(this.dumpPathString);
        this.method_37063((class_364)this.dumpPathPreviewText);
        this.summaryText = new class_7842(20, this.field_22790 - 89, this.field_22789 - 40, 20, (class_2561)class_2561.method_43469((String)"brrp.configScreen.summary", (Object[])new Object[]{RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.rootResources.", this.pack.numberOfRootResources()), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.clientResources.", this.pack.numberOfClientResources()), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.serverData.", this.pack.numberOfServerData())}), this.field_22793).method_48597().method_46438(-3355444);
        this.method_37063((class_364)this.summaryText);
        this.dumpProgressText = new class_7842(20, this.field_22790 - 73, this.field_22789 - 40, 20, class_5244.field_39003, this.field_22793).method_48597();
        this.method_37063((class_364)this.dumpProgressText);
        this.dumpButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dump"), button -> this.runDump()).method_46434(this.field_22789 / 2 - 200, this.field_22790 - 53, 200, 20).method_46431();
        this.method_37063((class_364)this.dumpButton);
        this.interruptButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.interrupt"), button -> {
            if (this.dumpThread != null) {
                this.dumpThread.interrupt();
                try {
                    this.dumpThread.join();
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupted dump screen:", (Throwable)e);
                }
            }
        }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.interrupt.tooltip"))).method_46434(this.field_22789 / 2, this.field_22790 - 53, 200, 20).method_46431();
        this.interruptButton.field_22763 = false;
        this.method_37063((class_364)this.interruptButton);
        this.backButton = class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431();
        this.method_37063((class_364)this.backButton);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
    }

    public void method_25393() {
        super.method_25393();
        boolean bl = this.dumpButton.field_22763 = this.invalidPathException == null && (this.dumpThread == null || !this.dumpThread.isAlive());
        if (this.dumpThread != null && this.dumpThread.isAlive()) {
            if (this.dumpStat[0] == -1) {
                this.dumpProgressText.method_25355((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.removeExisting"));
            } else {
                this.dumpProgressText.method_25355((class_2561)class_2561.method_43469((String)"brrp.dumpScreen.dumpSummary", (Object[])new Object[]{RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.rootResources.", this.dumpStat[0]), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.clientResources.", this.dumpStat[1]), RRPConfigScreen.PackListWidget.Entry.singleOrPlural("brrp.configScreen.summary.serverData.", this.dumpStat[2])}));
            }
        } else if (this.dumpThread != null) {
            this.dumpProgressText.method_25355(class_5244.field_24334);
        }
    }

    private void runDump() {
        this.runDump(false);
    }

    private void runDump(boolean ignoreExistingWarning) {
        try {
            if (!ignoreExistingWarning && PathUtils.isDirectory((Path)this.dumpPath, (LinkOption[])new LinkOption[0]) && !PathUtils.isEmptyDirectory((Path)this.dumpPath)) {
                long size = Files.walk(this.dumpPath, new FileVisitOption[0]).limit(2001L).count();
                if (this.field_22787 != null) {
                    this.dumpProgressText.method_25355(class_5244.field_39003);
                    this.field_22787.method_1507((class_437)new class_410(value -> {
                        if (this.field_22787 != null) {
                            this.field_22787.method_1507((class_437)this);
                            if (value) {
                                this.runDump(true);
                            }
                        }
                    }, (class_2561)class_2561.method_43471((String)"brrp.dumpScreen.existing.title"), (class_2561)class_2561.method_43469((String)"brrp.dumpScreen.existing.message", (Object[])new Object[]{size > 2000L ? class_2561.method_43469((String)"brrp.dumpScreen.existing.size", (Object[])new Object[]{2000}) : Long.valueOf(size), this.dumpPath.toAbsolutePath().toString()})));
                    return;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Checking whether the dump file exists:", (Throwable)e);
        }
        this.dumpThread = new Thread(() -> {
            this.interruptButton.field_22763 = true;
            this.backButton.field_22763 = false;
            this.dumpButton.method_25355((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dumping"));
            Arrays.fill(this.dumpStat, 0);
            this.pack.dumpInPath(this.dumpPath, this.dumpType.resourceType, this.dumpStat);
            this.dumpButton.method_25355((class_2561)class_2561.method_43471((String)"brrp.dumpScreen.dump"));
            this.interruptButton.field_22763 = false;
            this.backButton.field_22763 = true;
        }, "Dump pack");
        this.dumpThread.start();
    }

    public void method_25419() {
        if (this.dumpThread != null && this.dumpThread.isAlive()) {
            return;
        }
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum DumpType implements class_3542
    {
        ALL("all", null),
        CLIENT_RESOURCES("client_resources", class_3264.field_14188),
        SERVER_DATA("server_data", class_3264.field_14190);

        public final class_3264 resourceType;
        private final String name;

        private DumpType(String name, class_3264 resourceType) {
            this.name = name;
            this.resourceType = resourceType;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

