/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.impl;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_1860;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3495;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7367;
import net.minecraft.class_7475;
import net.minecraft.class_7788;
import net.minecraft.class_7877;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9224;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.function.FailableFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.JsonSerializers;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.impl.AbstractRuntimeResourcePack;
import pers.solid.brrp.v1.impl.BRRPBlockLootTableGenerator;
import pers.solid.brrp.v1.mixin.BuiltinRegistriesAccessor;
import pers.solid.brrp.v1.mixin.RegistryBuilderAccessor;

@ApiStatus.Internal
public class RuntimeResourcePackImpl
extends AbstractRuntimeResourcePack
implements class_3262 {
    public static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("BRRP-Workers-%s").build());
    private final Map<class_2960, Supplier<byte[]>> data = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();
    private final Map<class_2960, Supplier<byte[]>> assets = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    private final class_7225.class_7874 registryLookup;
    private final Gson gson;
    public final class_7788 blockLootTableGenerator;
    private static final class_5352 RUNTIME = class_5352.method_45281(name -> class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{name, class_2561.method_43471((String)"pack.source.runtime")}).method_27692(class_124.field_1080), (boolean)true);

    private static Gson createGson(class_7225.class_7874 registryLookup) {
        return GSON.newBuilder().registerTypeHierarchyAdapter(class_52.class, JsonSerializers.forCodec(class_52.field_50021, registryLookup)).registerTypeHierarchyAdapter(class_161.class, JsonSerializers.forCodec(class_161.field_47179, registryLookup)).registerTypeHierarchyAdapter(class_7475.class, JsonSerializers.forCodec(class_7475.field_39269, registryLookup)).registerTypeHierarchyAdapter(class_1860.class, JsonSerializers.forCodec(class_1860.field_47319, registryLookup)).create();
    }

    public RuntimeResourcePackImpl(class_2960 id, @NotNull class_7225.class_7874 registryLookup) {
        super(id);
        this.registryLookup = registryLookup;
        this.gson = RuntimeResourcePackImpl.createGson(registryLookup);
        this.blockLootTableGenerator = new BRRPBlockLootTableGenerator(registryLookup);
    }

    public RuntimeResourcePackImpl(class_2960 id) {
        super(id);
        this.registryLookup = Holder.registryLookup;
        this.gson = Holder.gson;
        this.blockLootTableGenerator = Holder.blockLootTableGenerator;
    }

    @Override
    public byte[] serialize(Object object) {
        return RuntimeResourcePack.serialize(object, this.gson);
    }

    private static class_2960 fix(class_2960 identifier, String prefix, String append) {
        return class_2960.method_60655((String)identifier.method_12836(), (String)(prefix + "/" + identifier.method_12832() + "." + append));
    }

    @Override
    public void addRecoloredImage(class_2960 identifier, InputStream target, IntUnaryOperator operator) {
        this.addLazyResource(class_3264.field_14188, RuntimeResourcePackImpl.fix(identifier, "textures", "png"), (i, r) -> {
            try {
                CountingInputStream is = new CountingInputStream(target);
                BufferedImage base = ImageIO.read((InputStream)is);
                BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), 2);
                for (int y = 0; y < base.getHeight(); ++y) {
                    for (int x = 0; x < base.getWidth(); ++x) {
                        recolored.setRGB(x, y, operator.applyAsInt(base.getRGB(x, y)));
                    }
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream(is.getCount());
                ImageIO.write((RenderedImage)recolored, "png", (OutputStream)stream);
                return stream.toByteArray();
            }
            catch (Throwable e) {
                LOGGER.error("Failed to add resources:", e);
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public byte[] addLang(class_2960 identifier, byte[] serializedData) {
        return this.addAsset(RuntimeResourcePackImpl.fix(identifier, "lang", "json"), serializedData);
    }

    @Override
    public byte[] addLootTable(class_2960 identifier, byte[] serializedData) {
        return this.addData(RuntimeResourcePackImpl.fix(identifier, "loot_table", "json"), serializedData);
    }

    @Override
    public Future<byte[]> addAsyncResource(class_3264 type, class_2960 path, FailableFunction<class_2960, byte[], Exception> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.apply((Object)path));
        Map<class_2960, Supplier<byte[]>> sys = this.getSys(type);
        if (!this.allowsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.getDisplayName().getString()));
        }
        sys.put(path, () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyResource(class_3264 type, class_2960 path, BiFunction<RuntimeResourcePack, class_2960, byte[]> func) {
        Map<class_2960, Supplier<byte[]>> sys = this.getSys(type);
        if (!this.allowsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.getDisplayName().getString()));
        }
        sys.put(path, (Supplier<byte[]>)Suppliers.memoize(() -> (byte[])func.apply(this, path)));
    }

    @Override
    public byte[] addResource(class_3264 type, class_2960 path, byte[] data) {
        Map<class_2960, Supplier<byte[]>> sys = this.getSys(type);
        if (!this.allowsDuplicateResource && sys.containsKey(path)) {
            throw new IllegalArgumentException(String.format("Duplicate resource id %s in runtime resource pack %s.", path, this.getDisplayName().getString()));
        }
        sys.put(path, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public Future<byte[]> addAsyncRootResource(String path, FailableFunction<String, byte[], Exception> data) {
        if (!this.allowsDuplicateResource && this.root.containsKey(Arrays.asList(path.split("/")))) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.getDisplayName().getString()));
        }
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.apply((Object)path));
        this.root.put(Arrays.asList(path.split("/")), () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data) {
        if (!this.allowsDuplicateResource && this.root.containsKey(Arrays.asList(path.split("/")))) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.getDisplayName().getString()));
        }
        this.root.put(Arrays.asList(path.split("/")), (Supplier<byte[]>)Suppliers.memoize(() -> (byte[])data.apply(this, path)));
    }

    @Override
    public byte[] addRootResource(String path, byte[] data) {
        if (!this.allowsDuplicateResource && this.root.containsKey(Arrays.asList(path.split("/")))) {
            throw new IllegalArgumentException(String.format("Duplicate root resource id %s in runtime resource pack %s!", path, this.getDisplayName().getString()));
        }
        this.root.put(Arrays.asList(path.split("/")), () -> data);
        return data;
    }

    @Override
    public byte[] addAsset(class_2960 id, byte[] data) {
        if (!this.allowsDuplicateResource && this.assets.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Duplicate asset id %s in runtime resource pack %s!", id, this.getDisplayName().getString()));
        }
        this.assets.put(id, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public byte[] addData(class_2960 id, byte[] data) {
        if (!this.allowsDuplicateResource && this.data.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Duplicate data id %s in runtime resource pack %s!", id, this.getDisplayName().getString()));
        }
        this.data.put(id, (Supplier<byte[]>)Suppliers.ofInstance((Object)data));
        return data;
    }

    @Override
    public byte[] addBlockState(class_2960 id, byte[] serializedData) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "blockstates", "json"), serializedData);
    }

    @Override
    public byte[] addModel(class_2960 id, byte[] serializedData) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "models", "json"), serializedData);
    }

    @Override
    public byte[] addTexture(class_2960 id, BufferedImage image) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", (OutputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException("impossible.", e);
        }
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png"), stream.toByteArray());
    }

    @Override
    public byte[] addTag(class_2960 fullId, byte[] serializedData) {
        return this.addData(RuntimeResourcePackImpl.fix(fullId, "tags", "json"), serializedData);
    }

    @Override
    public <T> byte[] addTag(class_6862<T> tagKey, class_3495 tagBuilder) {
        return this.addData(class_2960.method_60655((String)tagKey.comp_327().method_12836(), (String)(class_7924.method_60916((class_5321)tagKey.comp_326()) + "/" + tagKey.comp_327().method_12832() + ".json")), this.serialize(new class_7475(tagBuilder.method_26782(), false)));
    }

    @Override
    public byte[] addAnimation(class_2960 id, byte[] serializedData) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png.mcmeta"), serializedData);
    }

    @Override
    public byte[] addRecipe(class_2960 id, byte[] serializedData) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "recipe", "json"), serializedData);
    }

    @Override
    public byte[] addAdvancement(class_2960 id, byte[] serializedData) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "advancement", "json"), serializedData);
    }

    @Override
    public Future<?> async(Consumer<RuntimeResourcePack> action) {
        return EXECUTOR_SERVICE.submit(() -> action.accept(this));
    }

    @Override
    public void dumpInPath(Path output, @Nullable class_3264 dumpResourceType, int @Nullable [] stat) {
        LOGGER.info("Dumping {} in the path {}. The path will be cleared.", (Object)this.getDisplayName().getString(), (Object)output);
        try {
            if (stat != null) {
                stat[0] = -1;
            }
            if (output.toFile().exists()) {
                FileUtils.cleanDirectory((File)output.toFile());
            } else {
                Files.createDirectories(output, new FileAttribute[0]);
            }
            if (stat != null) {
                stat[2] = 0;
                stat[1] = 0;
                stat[0] = 0;
            }
            if (!this.root.isEmpty()) {
                for (Map.Entry<List<String>, Supplier<byte[]>> e : this.root.entrySet()) {
                    Path root = output.resolve(String.join((CharSequence)"/", (Iterable<? extends CharSequence>)e.getKey()));
                    Files.createDirectories(root.getParent(), new FileAttribute[0]);
                    Files.write(root, e.getValue().get(), new OpenOption[0]);
                    if (stat != null) {
                        stat[0] = stat[0] + 1;
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Dumping root resources");
                }
            }
            if (dumpResourceType != class_3264.field_14190 && !this.assets.isEmpty()) {
                Path assets = output.resolve("assets");
                Files.createDirectories(assets, new FileAttribute[0]);
                for (Map.Entry<class_2960, Supplier<byte[]>> entry : this.assets.entrySet()) {
                    this.write(assets, entry.getKey(), entry.getValue().get());
                    if (stat != null) {
                        stat[1] = stat[1] + 1;
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Dumping server data");
                }
            }
            if (dumpResourceType != class_3264.field_14188 && !this.data.isEmpty()) {
                Path data = output.resolve("data");
                Files.createDirectories(data, new FileAttribute[0]);
                for (Map.Entry<class_2960, Supplier<byte[]>> entry : this.data.entrySet()) {
                    this.write(data, entry.getKey(), entry.getValue().get());
                    if (stat != null) {
                        stat[2] = stat[2] + 1;
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Dumping client resources");
                }
            }
            LOGGER.info("Dumping {} finished.", (Object)this.getDisplayName().getString());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when dumping:", (Throwable)e);
        }
    }

    @Override
    public void load(Path dir) throws IOException {
        try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
            for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
                String path;
                String s = file.toString();
                if (s.startsWith("assets")) {
                    path = s.substring("assets".length() + 1);
                    this.load(path, this.assets, Files.readAllBytes(file));
                    continue;
                }
                if (s.startsWith("data")) {
                    path = s.substring("data".length() + 1);
                    this.load(path, this.data, Files.readAllBytes(file));
                    continue;
                }
                byte[] data = Files.readAllBytes(file);
                this.root.put(Arrays.asList(s.split("/")), () -> data);
            }
        }
    }

    @Override
    public void dump(ZipOutputStream zos) throws IOException {
        class_2960 id;
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.root.entrySet()) {
            zos.putNextEntry(new ZipEntry(String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey())));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.assets.entrySet()) {
            id = (class_2960)entry.getKey();
            zos.putNextEntry(new ZipEntry("assets/" + id.method_12836() + "/" + id.method_12832()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.data.entrySet()) {
            id = (class_2960)entry.getKey();
            zos.putNextEntry(new ZipEntry("data/" + id.method_12836() + "/" + id.method_12832()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
    }

    @Override
    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String path;
            String s = entry.toString();
            if (s.startsWith("assets")) {
                path = s.substring("assets".length() + 1);
                this.load(path, this.assets, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("data")) {
                path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            byte[] data = this.read(entry, stream);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    public class_7367<InputStream> method_14410(String ... segments) {
        Supplier<byte[]> supplier = this.root.get(Arrays.asList(segments));
        if (supplier == null) {
            return null;
        }
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        Supplier<byte[]> supplier = this.getSys(type).get(id);
        return supplier == null ? null : () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public void method_14408(class_3264 type, String namespace, String prefix, class_3262.class_7664 consumer) {
        for (class_2960 identifier : this.getSys(type).keySet()) {
            if (!identifier.method_12836().equals(namespace) || !identifier.method_12832().startsWith(prefix)) continue;
            consumer.accept((Object)identifier, this.method_14405(type, identifier));
        }
    }

    public Set<String> method_14406(class_3264 type) {
        HashSet<String> namespaces = new HashSet<String>();
        for (class_2960 identifier : this.getSys(type).keySet()) {
            namespaces.add(identifier.method_12836());
        }
        return namespaces;
    }

    public <T> T method_14407(class_3270<T> metaReader) {
        InputStream stream = null;
        try {
            class_7367<InputStream> supplier = this.method_14410("pack.mcmeta");
            if (supplier != null) {
                stream = (InputStream)supplier.get();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (stream != null) {
            return (T)class_3255.method_14392(metaReader, (InputStream)stream);
        }
        if (metaReader.method_14420().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)this.packVersion);
            class_2561 description = this.getDescription();
            object.add("description", (JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, description == null ? class_2561.method_43469((String)"brrp.pack.defaultDescription", (Object[])new Object[]{this.method_14409()}) : description).getOrThrow(JsonParseException::new));
            return (T)metaReader.method_14421(object);
        }
        return null;
    }

    public class_9224 method_56926() {
        return new class_9224(this.method_14409(), this.getDisplayName(), RUNTIME, Optional.empty());
    }

    public void close() {
        LOGGER.debug("Closing Runtime Resource Pack {}.", (Object)this.getDisplayName().getString());
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<class_2960, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(class_2960.method_60655((String)namespace, (String)path), () -> data);
    }

    private void write(Path dir, class_2960 identifier, byte[] data) {
        try {
            Path file = dir.resolve(identifier.method_12836()).resolve(identifier.method_12832());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clearResources(class_3264 side) {
        this.getSys(side).clear();
    }

    @Override
    public void clearResources() {
        this.assets.clear();
        this.data.clear();
        this.root.clear();
    }

    @Override
    public void clearRootResources() {
        this.root.clear();
    }

    @Override
    public int numberOfClientResources() {
        return this.assets.size();
    }

    @Override
    public int numberOfServerData() {
        return this.data.size();
    }

    @Override
    public int numberOfRootResources() {
        return this.root.size();
    }

    @Override
    public class_7225.class_7874 getRegistryLookup() {
        return this.registryLookup;
    }

    @Override
    public class_7788 getBlockLootTableGenerator() {
        return this.blockLootTableGenerator;
    }

    protected Map<class_2960, Supplier<byte[]>> getSys(class_3264 side) {
        return side == class_3264.field_14188 ? this.assets : this.data;
    }

    private static final class Holder {
        private static final class_7225.class_7874 registryLookup = (class_7225.class_7874)class_156.method_656(() -> {
            Workaround rb = Workaround.copy(BuiltinRegistriesAccessor.getRegistryBuilder());
            return rb.method_46780((class_5455)class_5455.method_40302((class_2378)class_7923.field_41167));
        });
        private static final Gson gson = RuntimeResourcePackImpl.createGson(registryLookup);
        private static final class_7788 blockLootTableGenerator = new BRRPBlockLootTableGenerator(registryLookup);

        private Holder() {
        }
    }

    public static class Workaround
    extends class_7877 {
        @Contract(pure=true)
        public static Workaround copy(class_7877 from) {
            Workaround rb = new Workaround();
            List<?> vanilla = ((RegistryBuilderAccessor)from).getRegistries();
            ((RegistryBuilderAccessor)((Object)rb)).getRegistries().addAll(vanilla);
            return rb;
        }
    }
}

