/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.tag;

import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_3497;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.mixin.TagBuilderAccessor;
import pers.solid.brrp.v1.tag.IdentifiedTagBuilder;

public class ObjectTagBuilder<T, Self extends ObjectTagBuilder<T, Self>>
extends class_3495 {
    public final Function<T, class_2960> valueToId;

    protected ObjectTagBuilder(Function<T, class_2960> valueToId) {
        this.valueToId = valueToId;
    }

    @Contract(value="_ -> new")
    public static <T> Impl<T> create(@NotNull Function<T, class_2960> valueToId) {
        return new Impl<T>(valueToId);
    }

    @Contract(value="_ -> new")
    public static <T> Impl<T> create(@NotNull class_2378<T> registry) {
        return ObjectTagBuilder.create(arg_0 -> registry.method_10221(arg_0));
    }

    @Contract(value="-> this")
    protected Self self() {
        return (Self)((Object)this);
    }

    @Contract(mutates="this")
    public Self add(@NotNull class_3497 entry) {
        super.method_27064(entry);
        return this.self();
    }

    @Contract(mutates="this")
    public Self add(@NotNull class_2960 id) {
        super.method_26784(id);
        return this.self();
    }

    @Contract(mutates="this")
    public Self addOptional(@NotNull class_2960 id) {
        super.method_34891(id);
        return this.self();
    }

    @Contract(mutates="this")
    public Self addTag(@NotNull class_2960 id) {
        super.method_26787(id);
        return this.self();
    }

    @Contract(mutates="this")
    public Self addTag(@NotNull class_6862<T> tagKey) {
        return this.addTag(tagKey.comp_327());
    }

    @SafeVarargs
    @Contract(mutates="this")
    public final Self addTag(class_6862<T> ... tagKeys) {
        for (class_6862<T> tagKey : tagKeys) {
            this.addTag(tagKey);
        }
        return this.self();
    }

    @Contract(mutates="this")
    public Self addTag(@NotNull IdentifiedTagBuilder<T> tagBuilder) {
        return this.addTag(tagBuilder.identifier);
    }

    @SafeVarargs
    @Contract(mutates="this")
    public final Self addTag(IdentifiedTagBuilder<T> ... tagBuilders) {
        for (IdentifiedTagBuilder<T> tagBuilder : tagBuilders) {
            this.addTag(tagBuilder);
        }
        return this.self();
    }

    @Contract(mutates="this")
    public Self addOptionalTag(@NotNull class_2960 id) {
        super.method_34892(id);
        return this.self();
    }

    @Contract(mutates="this")
    public Self add(T value) {
        return this.add((T)this.valueToId.apply(value));
    }

    @SafeVarargs
    @Contract(mutates="this")
    public final Self add(T ... value) {
        Arrays.stream(value).map(this.valueToId).forEach(this::add);
        return this.self();
    }

    @Contract(mutates="this")
    public Self copy(class_3495 copyFrom) {
        ((TagBuilderAccessor)copyFrom).getEntries().forEach(this::add);
        return this.self();
    }

    public static final class Impl<T>
    extends ObjectTagBuilder<T, Impl<T>> {
        public Impl(Function<T, class_2960> valueToId) {
            super(valueToId);
        }
    }
}

