/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.OrientationMode;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import net.minecraft.class_151;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public final class PropertiesParsingHelper {
    public static final Predicate<class_2680> EMPTY_BLOCK_STATE_PREDICATE = state -> false;

    @Nullable
    public static Set<class_2960> parseMatchTiles(Properties properties, String propertyKey, class_2960 fileLocation, String packName, @Nullable ResourceRedirectHandler redirectHandler) {
        String matchTilesStr = properties.getProperty(propertyKey);
        if (matchTilesStr == null) {
            return null;
        }
        String[] matchTileStrs = matchTilesStr.trim().split(" ");
        if (matchTileStrs.length != 0) {
            String basePath = FilenameUtils.getPath((String)fileLocation.method_12832());
            ObjectOpenHashSet set = new ObjectOpenHashSet();
            for (int i = 0; i < matchTileStrs.length; ++i) {
                String matchTileStr = matchTileStrs[i];
                if (matchTileStr.isEmpty()) continue;
                String[] parts = matchTileStr.split(":", 2);
                if (parts.length != 0) {
                    Object path;
                    String namespace;
                    if (parts.length > 1) {
                        namespace = parts[0];
                        path = parts[1];
                    } else {
                        namespace = null;
                        path = parts[0];
                    }
                    if (((String)path).endsWith(".png")) {
                        path = ((String)path).substring(0, ((String)path).length() - 4);
                    }
                    if (namespace == null) {
                        if (((String)path).startsWith("assets/minecraft/")) {
                            path = ((String)path).substring(17);
                        } else if (((String)path).startsWith("./")) {
                            path = basePath + ((String)path).substring(2);
                        } else if (((String)path).startsWith("~/")) {
                            path = "optifine/" + ((String)path).substring(2);
                        } else if (((String)path).startsWith("/")) {
                            path = "optifine/" + ((String)path).substring(1);
                        }
                    }
                    if (((String)path).startsWith("textures/")) {
                        path = ((String)path).substring(9);
                    } else if (((String)path).startsWith("optifine/")) {
                        if (redirectHandler == null) continue;
                        path = redirectHandler.getSourceSpritePath((String)path + ".png");
                        if (namespace == null) {
                            namespace = fileLocation.method_12836();
                        }
                    } else if (!((String)path).contains("/")) {
                        path = "block/" + (String)path;
                    }
                    if (namespace == null) {
                        namespace = "minecraft";
                    }
                    try {
                        set.add((Object)class_2960.method_60655((String)namespace, (String)path));
                    }
                    catch (class_151 e) {
                        ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + matchTileStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'", (Throwable)e);
                    }
                    continue;
                }
                ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + matchTileStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
            }
            set.trim();
            return set;
        }
        return Collections.emptySet();
    }

    @Nullable
    public static Predicate<class_2680> parseBlockStates(Properties properties, String propertyKey, class_2960 fileLocation, String packName) {
        String blockStatesStr = properties.getProperty(propertyKey);
        if (blockStatesStr == null) {
            return null;
        }
        String[] blockStateStrs = blockStatesStr.trim().split(" ");
        if (blockStateStrs.length != 0) {
            ReferenceOpenHashSet blockSet = new ReferenceOpenHashSet();
            Reference2ObjectOpenHashMap propertyMaps = new Reference2ObjectOpenHashMap();
            block2: for (int i = 0; i < blockStateStrs.length; ++i) {
                String blockStateStr = blockStateStrs[i].trim();
                if (blockStateStr.isEmpty()) continue;
                String[] parts = blockStateStr.split(":");
                if (parts.length != 0) {
                    int startIndex;
                    class_2960 blockId;
                    try {
                        if (parts.length == 1 || parts[1].contains("=")) {
                            blockId = class_2960.method_60656((String)parts[0]);
                            startIndex = 1;
                        } else {
                            blockId = class_2960.method_60655((String)parts[0], (String)parts[1]);
                            startIndex = 2;
                        }
                    }
                    catch (class_151 e) {
                        ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'", (Throwable)e);
                        continue;
                    }
                    if (class_7923.field_41175.method_10250(blockId)) {
                        class_2248 block2 = (class_2248)class_7923.field_41175.method_10223(blockId);
                        if (blockSet.contains((Object)block2)) continue;
                        if (parts.length > startIndex) {
                            Object2ObjectOpenHashMap propertyMap2 = new Object2ObjectOpenHashMap();
                            for (int j = startIndex; j < parts.length; ++j) {
                                String part = parts[j];
                                if (part.isEmpty()) continue;
                                String[] propertyParts = part.split("=", 2);
                                if (propertyParts.length == 2) {
                                    String propertyName = propertyParts[0];
                                    class_2769 property2 = block2.method_9595().method_11663(propertyName);
                                    if (property2 != null) {
                                        String propertyValuesStr = propertyParts[1];
                                        String[] propertyValueStrs = propertyValuesStr.split(",");
                                        if (propertyValueStrs.length != 0) {
                                            ObjectOpenHashSet valueSet2 = (ObjectOpenHashSet)propertyMap2.computeIfAbsent((Object)property2, p -> new ObjectOpenHashSet(16, 0.25f));
                                            for (String propertyValueStr : propertyValueStrs) {
                                                Optional optionalValue = property2.method_11900(propertyValueStr);
                                                if (!optionalValue.isPresent()) {
                                                    ContinuityClient.LOGGER.warn("Invalid block property value '" + propertyValueStr + "' for property '" + propertyName + "' for block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
                                                    continue block2;
                                                }
                                                valueSet2.add((Object)((Comparable)optionalValue.get()));
                                            }
                                            continue;
                                        }
                                        ContinuityClient.LOGGER.warn("Invalid block property definition for block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
                                        continue block2;
                                    }
                                    ContinuityClient.LOGGER.warn("Unknown block property '" + propertyName + "' for block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
                                    continue block2;
                                }
                                ContinuityClient.LOGGER.warn("Invalid block property definition for block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
                                continue block2;
                            }
                            if (propertyMap2.isEmpty()) continue;
                            Object2ObjectOpenHashMap existingPropertyMap = (Object2ObjectOpenHashMap)propertyMaps.get((Object)block2);
                            if (existingPropertyMap == null) {
                                propertyMaps.put((Object)block2, (Object)propertyMap2);
                                continue;
                            }
                            propertyMap2.forEach((property, valueSet) -> {
                                ObjectOpenHashSet existingValueSet = (ObjectOpenHashSet)existingPropertyMap.get(property);
                                if (existingValueSet == null) {
                                    existingPropertyMap.put(property, valueSet);
                                } else {
                                    existingValueSet.addAll((Collection)valueSet);
                                }
                            });
                            continue;
                        }
                        blockSet.add((Object)block2);
                        propertyMaps.remove((Object)block2);
                        continue;
                    }
                    ContinuityClient.LOGGER.warn("Unknown block '" + String.valueOf(blockId) + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
                    continue;
                }
                ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
            }
            if (!blockSet.isEmpty() || !propertyMaps.isEmpty()) {
                if (propertyMaps.isEmpty()) {
                    if (blockSet.size() == 1) {
                        class_2248 block3 = ((class_2248[])blockSet.toArray(class_2248[]::new))[0];
                        return state -> state.method_26204() == block3;
                    }
                    blockSet.trim();
                    return state -> blockSet.contains((Object)state.method_26204());
                }
                Reference2ReferenceOpenHashMap predicateMap = new Reference2ReferenceOpenHashMap();
                blockSet.forEach(block -> predicateMap.put(block, state -> true));
                propertyMaps.forEach((block, propertyMap) -> {
                    Map.Entry[] entryArray;
                    for (Map.Entry entry : entryArray = (Map.Entry[])propertyMap.entrySet().toArray(Map.Entry[]::new)) {
                        ((ObjectOpenHashSet)entry.getValue()).trim();
                    }
                    predicateMap.put(block, state -> {
                        Map targetValueMap = state.method_11656();
                        for (Map.Entry entry : entryArray) {
                            Comparable targetValue = (Comparable)targetValueMap.get(entry.getKey());
                            if (targetValue == null || ((ObjectOpenHashSet)entry.getValue()).contains((Object)targetValue)) continue;
                            return false;
                        }
                        return true;
                    });
                });
                return state -> {
                    Predicate predicate = (Predicate)predicateMap.get((Object)state.method_26204());
                    return predicate != null && predicate.test(state);
                };
            }
        }
        return EMPTY_BLOCK_STATE_PREDICATE;
    }

    @Nullable
    public static Symmetry parseSymmetry(Properties properties, String propertyKey, class_2960 fileLocation, String packName) {
        String symmetryStr = properties.getProperty(propertyKey);
        if (symmetryStr == null) {
            return null;
        }
        try {
            return Symmetry.valueOf(symmetryStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            ContinuityClient.LOGGER.warn("Unknown '" + propertyKey + "' value '" + symmetryStr + "' in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
            return null;
        }
    }

    @Nullable
    public static OrientationMode parseOrientationMode(Properties properties, String propertyKey, class_2960 fileLocation, String packName) {
        String orientationModeStr = properties.getProperty(propertyKey);
        if (orientationModeStr == null) {
            return null;
        }
        try {
            return OrientationMode.valueOf(orientationModeStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            ContinuityClient.LOGGER.warn("Unknown '" + propertyKey + "' value '" + orientationModeStr + "' in file '" + String.valueOf(fileLocation) + "' in pack '" + packName + "'");
            return null;
        }
    }

    public static boolean parseOptifineOnly(Properties properties, class_2960 fileLocation) {
        if (!fileLocation.method_12836().equals("minecraft")) {
            return false;
        }
        String optifineOnlyStr = properties.getProperty("optifineOnly");
        if (optifineOnlyStr == null) {
            return false;
        }
        return Boolean.parseBoolean(optifineOnlyStr.trim());
    }
}

