/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties.overlay;

import java.util.Locale;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.minecraft.class_151;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class OverlayPropertiesSection {
    protected Properties properties;
    protected class_2960 id;
    protected String packName;
    protected int tintIndex = -1;
    @Nullable
    protected class_2680 tintBlock;
    protected BlendMode layer = BlendMode.CUTOUT_MIPPED;

    public OverlayPropertiesSection(Properties properties, class_2960 id, String packName) {
        this.properties = properties;
        this.id = id;
        this.packName = packName;
    }

    public void init() {
        this.parseTintIndex();
        this.parseTintBlock();
        this.parseLayer();
    }

    protected void parseTintIndex() {
        String tintIndexStr = this.properties.getProperty("tintIndex");
        if (tintIndexStr == null) {
            return;
        }
        try {
            int tintIndex = Integer.parseInt(tintIndexStr.trim());
            if (tintIndex >= 0) {
                this.tintIndex = tintIndex;
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ContinuityClient.LOGGER.warn("Invalid 'tintIndex' value '" + tintIndexStr + "' in file '" + String.valueOf(this.id) + "' in pack '" + this.packName + "'");
    }

    protected void parseTintBlock() {
        String tintBlockStr = this.properties.getProperty("tintBlock");
        if (tintBlockStr == null) {
            return;
        }
        String[] parts = tintBlockStr.trim().split(":", 3);
        if (parts.length != 0) {
            class_2960 blockId;
            try {
                blockId = parts.length == 1 || parts[1].contains("=") ? class_2960.method_60656((String)parts[0]) : class_2960.method_60655((String)parts[0], (String)parts[1]);
            }
            catch (class_151 e) {
                ContinuityClient.LOGGER.warn("Invalid 'tintBlock' value '" + tintBlockStr + "' in file '" + String.valueOf(this.id) + "' in pack '" + this.packName + "'", (Throwable)e);
                return;
            }
            if (class_7923.field_41175.method_10250(blockId)) {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
                this.tintBlock = block.method_9564();
            } else {
                ContinuityClient.LOGGER.warn("Unknown block '" + String.valueOf(blockId) + "' in 'tintBlock' value '" + tintBlockStr + "' in file '" + String.valueOf(this.id) + "' in pack '" + this.packName + "'");
            }
        } else {
            ContinuityClient.LOGGER.warn("Invalid 'tintBlock' value '" + tintBlockStr + "' in file '" + String.valueOf(this.id) + "' in pack '" + this.packName + "'");
        }
    }

    protected void parseLayer() {
        String layerStr1;
        String layerStr = this.properties.getProperty("layer");
        if (layerStr == null) {
            return;
        }
        switch (layerStr1 = layerStr.trim().toLowerCase(Locale.ROOT)) {
            case "cutout_mipped": {
                this.layer = BlendMode.CUTOUT_MIPPED;
                break;
            }
            case "cutout": {
                this.layer = BlendMode.CUTOUT;
                break;
            }
            case "translucent": {
                this.layer = BlendMode.TRANSLUCENT;
                break;
            }
            default: {
                ContinuityClient.LOGGER.warn("Unknown 'layer' value '" + layerStr + " in file '" + String.valueOf(this.id) + "' in pack '" + this.packName + "'");
            }
        }
    }

    public int getTintIndex() {
        return this.tintIndex;
    }

    @Nullable
    public class_2680 getTintBlock() {
        return this.tintBlock;
    }

    public BlendMode getLayer() {
        return this.layer;
    }

    public static interface Provider {
        public OverlayPropertiesSection getOverlayPropertiesSection();
    }
}

