/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.yumi.commons.TriState;
import dev.yumi.commons.event.Event;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemLightSources
implements ItemLightSourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|ItemLightSources");
    private static final String SILENCE_ERROR_KEY = "silence_error";
    private static final boolean FORCE_LOG_ERRORS = TriState.fromProperty("lambdynamiclights.resource.force_log_errors").toBooleanOrElse(FabricLoader.getInstance().isDevelopmentEnvironment());
    private final Event<class_2960, ItemLightSourceManager.OnRegister> onRegisterEvent = LambDynLights.EVENT_MANAGER.create(ItemLightSourceManager.OnRegister.class);
    private final List<LoadedItemLightSource> loadedLightSources = new ArrayList<LoadedItemLightSource>();
    private final List<ItemLightSource> lightSources = new ArrayList<ItemLightSource>();

    public void load(class_3300 resourceManager) {
        this.loadedLightSources.clear();
        resourceManager.method_14488("dynamiclights/item", path -> path.method_12832().endsWith(".json")).forEach(this::load);
    }

    public void apply(final class_5455 registryAccess) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
        this.lightSources.clear();
        this.loadedLightSources.forEach(data -> this.apply((DynamicOps<JsonElement>)ops, (LoadedItemLightSource)data));
        this.onRegisterEvent.invoker().onRegister(new ItemLightSourceManager.RegisterContext(){

            @Override
            public class_5455 registryAccess() {
                return registryAccess;
            }

            @Override
            public void register(ItemLightSource itemLightSource) {
                ItemLightSources.this.lightSources.add(itemLightSource);
            }
        });
    }

    private void load(class_2960 resourceId, class_3298 resource) {
        class_2960 id = class_2960.method_60655((String)resourceId.method_12836(), (String)resourceId.method_12832().replace(".json", ""));
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
            JsonElement rawJson = JsonParser.parseReader((Reader)reader);
            if (!rawJson.isJsonObject()) {
                LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\". Expected JSON object in file.", id);
                return;
            }
            JsonObject json = rawJson.getAsJsonObject();
            boolean silentError = false;
            if (json.has(SILENCE_ERROR_KEY)) {
                silentError = json.get(SILENCE_ERROR_KEY).getAsBoolean();
                json.remove(SILENCE_ERROR_KEY);
            }
            this.loadedLightSources.add(new LoadedItemLightSource(id, json, silentError));
        }
        catch (IOException | IllegalStateException e) {
            LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\".", id, e);
        }
    }

    private void apply(DynamicOps<JsonElement> ops, LoadedItemLightSource loadedData) {
        DataResult loaded = ItemLightSource.CODEC.parse(ops, (Object)loadedData.data());
        if (!loadedData.silenceError() || FORCE_LOG_ERRORS) {
            loaded.ifError(error -> LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\" due to error: {}", loadedData.id(), error.message()));
        }
        loaded.ifSuccess(this.lightSources::add);
    }

    @Override
    public Event<class_2960, ItemLightSourceManager.OnRegister> onRegisterEvent() {
        return this.onRegisterEvent;
    }

    @Override
    public int getLuminance(class_1799 stack, boolean submergedInWater) {
        boolean shouldCareAboutWater = submergedInWater && (Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get() != false;
        int luminance = class_2248.method_9503((class_1792)stack.method_7909()).method_9564().method_26213();
        for (ItemLightSource data : this.lightSources) {
            if (shouldCareAboutWater && data.waterSensitive()) continue;
            luminance = Math.max(luminance, data.getLuminance(stack));
        }
        return luminance;
    }

    record LoadedItemLightSource(class_2960 id, JsonObject data, boolean silenceError) {
    }
}

