/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.collections.toposort;

import dev.yumi.commons.collections.toposort.SortableNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeSorting {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeSorting.class);
    @VisibleForTesting
    public static boolean ENABLE_CYCLE_WARNING = true;

    private NodeSorting() {
        throw new UnsupportedOperationException("NodeSorting only contains static-definitions.");
    }

    public static <I extends Comparable<? super I>, N extends SortableNode<I, N>> boolean sort(@NotNull List<N> sortedNodes, @NotNull String elementDescription) {
        return NodeSorting.sort(sortedNodes, elementDescription, Comparator.comparing(SortableNode::getId));
    }

    public static <I, N extends SortableNode<I, N>> boolean sort(@NotNull List<N> sortedNodes, @NotNull String elementDescription, @NotNull Comparator<N> comparator) {
        ArrayList toposort = new ArrayList(sortedNodes.size());
        for (Iterator node : sortedNodes) {
            NodeSorting.forwardVisit(node, toposort);
        }
        NodeSorting.clearStatus(toposort);
        Collections.reverse(toposort);
        IdentityHashMap nodeToScc = new IdentityHashMap();
        for (SortableNode node : toposort) {
            if (node.visited) continue;
            ArrayList<N> sccNodes = new ArrayList<N>();
            NodeSorting.backwardVisit(node, sccNodes);
            sccNodes.sort(comparator);
            NodeScc scc2 = new NodeScc(sccNodes);
            Iterator<Object> iterator = sccNodes.iterator();
            while (iterator.hasNext()) {
                SortableNode nodeInScc = (SortableNode)iterator.next();
                nodeToScc.put(nodeInScc, scc2);
            }
        }
        NodeSorting.clearStatus(toposort);
        for (Object scc3 : nodeToScc.values()) {
            for (SortableNode node : ((NodeScc)scc3).nodes) {
                for (SortableNode nextNode : node.nextNodes) {
                    NodeScc nextScc = (NodeScc)nodeToScc.get(nextNode);
                    if (nextScc == scc3) continue;
                    ((NodeScc)scc3).nextSccs.add(nextScc);
                    ++nextScc.inDegree;
                }
            }
        }
        PriorityQueue<NodeScc> pq = new PriorityQueue<NodeScc>(Comparator.comparing(scc -> (SortableNode)scc.nodes.get(0), comparator));
        sortedNodes.clear();
        for (NodeScc scc4 : nodeToScc.values()) {
            if (scc4.inDegree != 0) continue;
            pq.add(scc4);
            scc4.inDegree = -1;
        }
        boolean noCycle = true;
        while (!pq.isEmpty()) {
            NodeScc scc4;
            scc4 = pq.poll();
            sortedNodes.addAll(scc4.nodes);
            if (scc4.nodes.size() > 1) {
                noCycle = false;
                if (ENABLE_CYCLE_WARNING) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Found cycle while sorting ").append(elementDescription).append(":\n");
                    for (SortableNode node : scc4.nodes) {
                        builder.append("\t").append(node.getId()).append("\n");
                    }
                    LOGGER.warn("{}", (Object)builder);
                }
            }
            for (NodeScc nextScc : scc4.nextSccs) {
                --nextScc.inDegree;
                if (nextScc.inDegree != 0) continue;
                pq.add(nextScc);
            }
        }
        return noCycle;
    }

    @ApiStatus.Internal
    private static <I, N extends SortableNode<I, N>> void forwardVisit(N node, List<N> toposort) {
        if (!node.visited) {
            node.visited = true;
            for (SortableNode data : node.nextNodes) {
                NodeSorting.forwardVisit(data, toposort);
            }
            toposort.add(node);
        }
    }

    @ApiStatus.Internal
    private static <I, N extends SortableNode<I, N>> void clearStatus(List<N> nodes) {
        for (SortableNode node : nodes) {
            node.visited = false;
        }
    }

    @ApiStatus.Internal
    private static <I, N extends SortableNode<I, N>> void backwardVisit(N node, List<N> sccNodes) {
        if (!node.visited) {
            node.visited = true;
            sccNodes.add(node);
            for (SortableNode data : node.previousNodes) {
                NodeSorting.backwardVisit(data, sccNodes);
            }
        }
    }

    @ApiStatus.Internal
    private static class NodeScc<I, N extends SortableNode<I, N>> {
        final List<N> nodes;
        final List<NodeScc<I, N>> nextSccs = new ArrayList<NodeScc<I, N>>();
        int inDegree = 0;

        private NodeScc(List<N> nodes) {
            this.nodes = nodes;
        }
    }
}

