/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.collections.toposort;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class SortableNode<I, N extends SortableNode<I, N>> {
    final List<N> nextNodes = new ArrayList<N>();
    final List<N> previousNodes = new ArrayList<N>();
    boolean visited = false;

    @Contract(pure=true)
    @NotNull
    public abstract I getId();

    public static <I, N extends SortableNode<I, N>> void link(@NotNull N first, @NotNull N second) {
        if (first == second) {
            throw new IllegalArgumentException("Cannot link a node to itself!");
        }
        first.nextNodes.add(second);
        second.previousNodes.add(first);
    }
}

