/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event;

import dev.yumi.commons.collections.toposort.SortableNode;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class EventPhaseData<I, T>
extends SortableNode<I, EventPhaseData<I, T>> {
    private final I id;
    T[] listeners;

    EventPhaseData(@NotNull I id, @NotNull Class<? super T> listenerType) {
        Objects.requireNonNull(id);
        this.id = id;
        this.listeners = (Object[])Array.newInstance(listenerType, 0);
    }

    @Override
    @NotNull
    public I getId() {
        return this.id;
    }

    public void addListener(@NotNull T listener) {
        int oldLength = this.listeners.length;
        this.listeners = Arrays.copyOf(this.listeners, oldLength + 1);
        this.listeners[oldLength] = listener;
    }
}

