/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event.invoker;

final class Descriptors {
    public static final String VOID = "V";
    public static final String BOOLEAN = "Z";
    public static final String CHAR = "C";
    public static final String BYTE = "B";
    public static final String SHORT = "S";
    public static final String INT = "I";
    public static final String LONG = "J";
    public static final String FLOAT = "F";
    public static final String DOUBLE = "D";

    private Descriptors() {
        throw new UnsupportedOperationException("Descriptors only contain static definitions.");
    }

    public static String describe(Class<?> c) {
        if (c == Void.TYPE) {
            return VOID;
        }
        if (c == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (c == Character.TYPE) {
            return CHAR;
        }
        if (c == Byte.TYPE) {
            return BYTE;
        }
        if (c == Short.TYPE) {
            return SHORT;
        }
        if (c == Integer.TYPE) {
            return INT;
        }
        if (c == Long.TYPE) {
            return LONG;
        }
        if (c == Float.TYPE) {
            return FLOAT;
        }
        if (c == Double.TYPE) {
            return DOUBLE;
        }
        if (c.isArray()) {
            return "[" + Descriptors.describe(c.componentType());
        }
        return "L" + c.getName().replace('.', '/') + ";";
    }

    public static int getTypeSize(String descriptor) {
        return switch (descriptor) {
            case LONG, DOUBLE -> 2;
            default -> 1;
        };
    }
}

