/*
 * Decompiled with CFR 0.152.
 */
package dev.yurisuika.raised.util.config;

import dev.yurisuika.raised.util.config.Config;
import dev.yurisuika.raised.util.config.options.Layers;
import dev.yurisuika.raised.util.config.options.Properties;
import dev.yurisuika.raised.util.config.options.Resources;
import dev.yurisuika.raised.util.properties.Element;
import dev.yurisuika.raised.util.properties.Position;
import dev.yurisuika.raised.util.properties.Sync;
import dev.yurisuika.raised.util.resources.Texture;

public class Option {
    public static Layers getLayers() {
        return Config.getOptions().getLayers();
    }

    public static void setLayers(Layers layers) {
        Config.getOptions().setLayers(layers);
        Config.saveConfig();
    }

    public static Properties getProperties(Element element) {
        return switch (element) {
            default -> throw new MatchException(null, null);
            case Element.HOTBAR -> Option.getLayers().getHotbar();
            case Element.CHAT -> Option.getLayers().getChat();
            case Element.BOSSBAR -> Option.getLayers().getBossbar();
            case Element.SIDEBAR -> Option.getLayers().getSidebar();
            case Element.EFFECTS -> Option.getLayers().getEffects();
            case Element.PLAYERS -> Option.getLayers().getPlayers();
            case Element.TOASTS -> Option.getLayers().getToasts();
            case Element.OTHER -> Option.getLayers().getOther();
        };
    }

    public static void setProperties(Element element, Properties properties) {
        switch (element) {
            case HOTBAR: {
                Option.getLayers().setHotbar(properties);
                break;
            }
            case CHAT: {
                Option.getLayers().setChat(properties);
                break;
            }
            case BOSSBAR: {
                Option.getLayers().setBossbar(properties);
                break;
            }
            case SIDEBAR: {
                Option.getLayers().setSidebar(properties);
                break;
            }
            case EFFECTS: {
                Option.getLayers().setEffects(properties);
                break;
            }
            case PLAYERS: {
                Option.getLayers().setPlayers(properties);
                break;
            }
            case TOASTS: {
                Option.getLayers().setToasts(properties);
                break;
            }
            case OTHER: {
                Option.getLayers().setOther(properties);
            }
        }
        Config.saveConfig();
    }

    public static int getX(Element element) {
        return Option.getProperties(element).getX();
    }

    public static void setX(Element element, int x) {
        Option.getProperties(element).setX(x);
        Config.saveConfig();
    }

    public static int getY(Element element) {
        return Option.getProperties(element).getY();
    }

    public static void setY(Element element, int y) {
        Option.getProperties(element).setY(y);
        Config.saveConfig();
    }

    public static Position getPosition(Element element) {
        return Option.getProperties(element).getPosition();
    }

    public static void setPosition(Element element, Position position) {
        Option.getProperties(element).setPosition(position);
        Config.saveConfig();
    }

    public static Sync getSync(Element element) {
        return Option.getProperties(element).getSync();
    }

    public static void setSync(Element element, Sync sync) {
        Option.getProperties(element).setSync(sync);
        Config.saveConfig();
    }

    public static Resources getResources() {
        return Config.getOptions().getResources();
    }

    public static void setResources(Resources resources) {
        Config.getOptions().setResources(resources);
        Config.saveConfig();
    }

    public static Texture getTexture() {
        return Option.getResources().getTexture();
    }

    public static void setTexture(Texture texture) {
        Option.getResources().setTexture(texture);
        Config.saveConfig();
    }
}

