/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.cit;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_2960;
import shcm.shsupercm.fabric.citresewn.CITResewn;
import shcm.shsupercm.fabric.citresewn.api.CITConditionContainer;
import shcm.shsupercm.fabric.citresewn.api.CITTypeContainer;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.cit.CITType;
import shcm.shsupercm.fabric.citresewn.cit.UnknownCITTypeException;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.ConstantCondition;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public final class CITRegistry {
    public static final Map<class_2960, CITTypeContainer<? extends CITType>> TYPES = new HashMap<class_2960, CITTypeContainer<? extends CITType>>();
    public static final Map<PropertyKey, CITConditionContainer<? extends CITCondition>> CONDITIONS = new HashMap<PropertyKey, CITConditionContainer<? extends CITCondition>>();
    private static final Map<Class<? extends CITType>, class_2960> TYPE_TO_ID = new IdentityHashMap<Class<? extends CITType>, class_2960>();
    private static final Map<Class<? extends CITCondition>, PropertyKey> CONDITION_TO_ID = new IdentityHashMap<Class<? extends CITCondition>, PropertyKey>();

    private CITRegistry() {
    }

    public static void registerAll() {
        String namespace;
        CITResewn.info("Registering CIT Conditions");
        for (EntrypointContainer entrypointContainer : FabricLoader.getInstance().getEntrypointContainers("citresewn:condition", CITConditionContainer.class)) {
            namespace = entrypointContainer.getProvider().getMetadata().getId();
            if (namespace.equals("citresewn-defaults")) {
                namespace = "citresewn";
            }
            for (String alias : ((CITConditionContainer)entrypointContainer.getEntrypoint()).aliases) {
                PropertyKey key = new PropertyKey(namespace, alias);
                CITConditionContainer container = (CITConditionContainer)entrypointContainer.getEntrypoint();
                CONDITIONS.put(key, container);
                CONDITION_TO_ID.putIfAbsent(((CITCondition)container.createCondition.get()).getClass(), key);
            }
        }
        CITResewn.info("Registering CIT Types");
        for (EntrypointContainer entrypointContainer : FabricLoader.getInstance().getEntrypointContainers("citresewn:type", CITTypeContainer.class)) {
            namespace = entrypointContainer.getProvider().getMetadata().getId();
            if (namespace.equals("citresewn-defaults")) {
                namespace = "citresewn";
            }
            class_2960 id = class_2960.method_60655((String)namespace, (String)((CITTypeContainer)entrypointContainer.getEntrypoint()).id);
            CITTypeContainer container = (CITTypeContainer)entrypointContainer.getEntrypoint();
            TYPES.put(id, container);
            TYPE_TO_ID.putIfAbsent(((CITType)container.createType.get()).getClass(), id);
        }
    }

    public static CITCondition parseCondition(PropertyKey key, PropertyValue value, PropertyGroup properties) throws CITParsingException {
        CITConditionContainer<? extends CITCondition> conditionContainer = CONDITIONS.get(key);
        if (conditionContainer == null) {
            CITResewn.logWarnLoading(properties.messageWithDescriptorOf("Unknown condition type \"" + key.toString() + "\"", value.position()));
            return ConstantCondition.FALSE;
        }
        CITCondition condition = (CITCondition)conditionContainer.createCondition.get();
        condition.load(key, value, properties);
        return condition;
    }

    public static CITType parseType(PropertyGroup properties) throws UnknownCITTypeException {
        CITTypeContainer<? extends CITType> typeContainer;
        class_2960 type = class_2960.method_60655((String)"citresewn", (String)"item");
        PropertyValue propertiesType = properties.getLastWithoutMetadata("citresewn", "type");
        if (propertiesType != null) {
            Object value = propertiesType.value();
            if (!((String)value).contains(":")) {
                value = "citresewn:" + (String)value;
            }
            type = class_2960.method_12829((String)value);
        }
        if ((typeContainer = TYPES.get(type)) == null) {
            throw new UnknownCITTypeException(properties, propertiesType == null ? -1 : propertiesType.position());
        }
        return (CITType)typeContainer.createType.get();
    }

    public static class_2960 idOfType(Class<? extends CITType> clazz) {
        return TYPE_TO_ID.get(clazz);
    }

    public static PropertyKey idOfCondition(Class<? extends CITCondition> clazz) {
        return CONDITION_TO_ID.get(clazz);
    }
}

