/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl;

import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.api.ChestTrackerPlugin;
import red.jackf.chesttracker.api.gui.ScreenBlacklist;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.gui.DeveloperOverlay;
import red.jackf.chesttracker.impl.gui.invbutton.ButtonPositionMap;
import red.jackf.chesttracker.impl.gui.invbutton.CTButtonScreenDuck;
import red.jackf.chesttracker.impl.gui.invbutton.InventoryButtonFeature;
import red.jackf.chesttracker.impl.gui.screen.ChestTrackerScreen;
import red.jackf.chesttracker.impl.gui.util.CTTitleOverrideDuck;
import red.jackf.chesttracker.impl.gui.util.ImagePixelReader;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryIntegrity;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.key.OverrideInfo;
import red.jackf.chesttracker.impl.providers.InteractionTrackerImpl;
import red.jackf.chesttracker.impl.providers.ProviderHandler;
import red.jackf.chesttracker.impl.providers.ScreenCloseContextImpl;
import red.jackf.chesttracker.impl.providers.ScreenOpenContextImpl;
import red.jackf.chesttracker.impl.rendering.NameRenderer;
import red.jackf.chesttracker.impl.storage.ConnectionSettings;
import red.jackf.chesttracker.impl.storage.Storage;
import red.jackf.whereisit.client.api.events.ShouldIgnoreKey;

@Environment(value=EnvType.CLIENT)
public class ChestTracker
implements ClientModInitializer {
    public static final String ID = "chesttracker";
    public static final Logger LOGGER = LogManager.getLogger();
    private static boolean shouldSkipProviderForNextGuiClose = false;
    public static final class_304 OPEN_GUI = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.chesttracker.open_gui", class_3675.class_307.field_1668, 96, "chesttracker.title"));

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    public static Logger getLogger(String suffix) {
        return LogManager.getLogger((String)(ChestTracker.class.getCanonicalName() + "/" + suffix));
    }

    public static void openInGame(class_310 client, @Nullable class_437 parent) {
        client.method_1507((class_437)new ChestTrackerScreen(parent));
    }

    public static void skipProviderForNextGuiClose() {
        shouldSkipProviderForNextGuiClose = true;
    }

    public void onInitializeClient() {
        ChestTrackerConfig.init();
        LOGGER.debug("Loading ChestTracker");
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (client.field_1755 == null && client.method_18506() == null) {
                while (OPEN_GUI.method_1436()) {
                    ChestTracker.openInGame(client, null);
                }
            }
        });
        ClientTickEvents.START_WORLD_TICK.register(ignored -> MemoryBankAccessImpl.INSTANCE.getLoadedInternal().ifPresent(bank -> bank.getMetadata().incrementLoadedTime()));
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_465) {
                class_465 containerScreen = (class_465)screen;
                ProviderHandler.INSTANCE.getCurrentProvider().ifPresent(provider -> {
                    ScreenOpenContextImpl openContext = ScreenOpenContextImpl.createFor(containerScreen);
                    provider.onScreenOpen(openContext);
                    ((CTButtonScreenDuck)containerScreen).chesttracker$setContext(openContext);
                    if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.useCustomNameInGUIs) {
                        MemoryBankAccessImpl.INSTANCE.getLoadedInternal().ifPresent(bank -> {
                            Optional<MemoryKeyImpl> key;
                            if (openContext.getTarget() != null && (key = bank.getKeyInternal(openContext.getTarget().memoryKey())).isPresent()) {
                                OverrideInfo override = key.get().overrides().get(openContext.getTarget().position());
                                if (override != null) {
                                    if (override.getCustomName() != null) {
                                        ((CTTitleOverrideDuck)containerScreen).chesttracker$setTitleOverride((class_2561)class_2561.method_43470((String)override.getCustomName()));
                                    } else {
                                        ((CTTitleOverrideDuck)containerScreen).chesttracker$clearTitleOverride();
                                    }
                                } else {
                                    ((CTTitleOverrideDuck)containerScreen).chesttracker$clearTitleOverride();
                                }
                            }
                        });
                    }
                });
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (class_310.method_1551().field_1687 == null) {
                return;
            }
            if (screen instanceof class_465) {
                ScreenKeyboardEvents.afterKeyPress((class_437)screen).register((parent, key, scancode, modifiers) -> {
                    if (((ShouldIgnoreKey)ShouldIgnoreKey.EVENT.invoker()).shouldIgnoreKey()) {
                        return;
                    }
                    if (OPEN_GUI.method_1417(key, scancode)) {
                        ChestTracker.openInGame(client, parent);
                    }
                });
                InventoryButtonFeature.onScreenOpen(client, screen, scaledWidth, scaledHeight);
                if (!ScreenBlacklist.isBlacklisted(screen.getClass())) {
                    ScreenEvents.remove((class_437)screen).register(screen1 -> {
                        if (!shouldSkipProviderForNextGuiClose) {
                            ProviderHandler.INSTANCE.getCurrentProvider().ifPresent(provider -> provider.onScreenClose(ScreenCloseContextImpl.createFor((class_465)screen1)));
                            InteractionTrackerImpl.INSTANCE.clear();
                        } else {
                            shouldSkipProviderForNextGuiClose = false;
                        }
                    });
                } else {
                    LOGGER.debug("Blacklisted screen class, ignoring");
                }
            }
        });
        InventoryButtonFeature.setup();
        ProviderHandler.INSTANCE.setupEvents();
        NameRenderer.setup();
        InteractionTrackerImpl.setup();
        MemoryIntegrity.setup();
        ImagePixelReader.setup();
        Storage.setup();
        DeveloperOverlay.setup();
        ConnectionSettings.load();
        ButtonPositionMap.loadUserPositions();
        for (EntrypointContainer container : FabricLoader.getInstance().getEntrypointContainers(ID, ChestTrackerPlugin.class)) {
            LOGGER.debug("Loading entrypoint from mod {}", (Object)container.getProvider().getMetadata().getId());
            ((ChestTrackerPlugin)container.getEntrypoint()).load();
        }
    }
}

