/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.compat.mods.jade;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2363;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import red.jackf.chesttracker.api.memory.Memory;
import red.jackf.chesttracker.api.memory.MemoryBankAccess;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.util.ItemStacks;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ScreenDirection;

@Environment(value=EnvType.CLIENT)
public class JadeClientContentsPreview
implements IBlockComponentProvider {
    public static JadeClientContentsPreview INSTANCE = new JadeClientContentsPreview();
    public static final class_2960 ID = ChestTracker.id("memory_preview");

    private JadeClientContentsPreview() {
    }

    private static void possiblyAddItems(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config, Memory memory) {
        int i;
        if (config.get(JadeIds.UNIVERSAL_ITEM_STORAGE) && accessor.getServerData().method_10545("JadeItemStorage")) {
            return;
        }
        if (config.get(JadeIds.MC_FURNACE) && accessor.getBlock() instanceof class_2363 && accessor.getServerData().method_10573("furnace", 9)) {
            return;
        }
        List<class_1799> stacks = ItemStacks.flattenStacks(memory.items(), true);
        int max = config.getInt(accessor.showDetails() ? JadeIds.UNIVERSAL_ITEM_STORAGE_DETAILED_AMOUNT : JadeIds.UNIVERSAL_ITEM_STORAGE_NORMAL_AMOUNT);
        int perLine = config.getInt(JadeIds.UNIVERSAL_ITEM_STORAGE_ITEMS_PER_LINE);
        ArrayList lines = new ArrayList();
        ArrayList<IElement> currentLine = new ArrayList<IElement>(perLine);
        for (i = 0; i < max && i < stacks.size(); ++i) {
            class_1799 item = stacks.get(i);
            currentLine.add(IElementHelper.get().item(item));
            if (currentLine.size() != perLine) continue;
            lines.add(currentLine);
            currentLine = new ArrayList(perLine);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine);
        }
        for (i = 0; i < lines.size(); ++i) {
            tooltip.add((List)lines.get(i));
            if (i >= lines.size() - 1) continue;
            tooltip.setLineMargin(-1, ScreenDirection.DOWN, -1);
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        MemoryBankAccess.INSTANCE.getLoaded().ifPresent(bank -> {
            Optional<Memory> memory = bank.getMemory(accessor.getLevel(), accessor.getPosition());
            if (memory.isEmpty()) {
                return;
            }
            JadeClientContentsPreview.possiblyAddItems(tooltip, accessor, config, memory.get());
            class_2561 name = memory.get().renderName();
            if (name != null) {
                tooltip.replace(JadeIds.CORE_OBJECT_NAME, (class_2561)IThemeHelper.get().title((Object)name));
            }
        });
    }

    public class_2960 getUid() {
        return ID;
    }
}

