/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.invbutton;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import net.minecraft.class_465;
import red.jackf.chesttracker.impl.gui.invbutton.position.ButtonPosition;
import red.jackf.chesttracker.impl.util.Constants;
import red.jackf.chesttracker.impl.util.FileUtil;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;

@Environment(value=EnvType.CLIENT)
public class ButtonPositionMap {
    private static final ButtonPosition FALLBACK_DEFAULT = new ButtonPosition(ButtonPosition.HorizontalAlignment.right, 14, ButtonPosition.VerticalAlignment.top, 5);
    private static final Path USER_PATH = Constants.STORAGE_DIR.resolve("user_button_positions.dat");
    protected static final Codec<Map<String, ButtonPosition>> USER_CODEC = JFLCodecs.mutableMap((Codec)Codec.unboundedMap((Codec)Codec.STRING, ButtonPosition.CODEC));
    private static final Map<String, ButtonPosition> datapackPositions = new HashMap<String, ButtonPosition>();
    private static final Map<String, ButtonPosition> userPositions = new HashMap<String, ButtonPosition>();

    public static void loadDatapackPositions(Map<String, ButtonPosition> datapack) {
        datapackPositions.clear();
        datapackPositions.putAll(datapack);
    }

    public static void loadUserPositions() {
        userPositions.clear();
        FileUtil.loadFromNbt(USER_CODEC, USER_PATH, null).ifPresent(userPositions::putAll);
    }

    public static Map<String, ButtonPosition> getUserPositions() {
        return ImmutableMap.copyOf(userPositions);
    }

    public static void removeUserPosition(String position) {
        boolean result;
        boolean bl = result = userPositions.remove(position) != null;
        if (result) {
            ButtonPositionMap.saveUserPositions();
        }
    }

    private static void saveUserPositions() {
        FileUtil.saveToNbt(userPositions, USER_CODEC, USER_PATH, null);
    }

    public static String getClassString(class_465<?> screen) {
        String className = screen.getClass().getCanonicalName();
        MappingResolver mapper = FabricLoader.getInstance().getMappingResolver();
        if (!mapper.getCurrentRuntimeNamespace().equals("intermediary") && mapper.getNamespaces().contains("intermediary")) {
            className = mapper.unmapClassName("intermediary", className);
        }
        return className;
    }

    public static void saveUserPosition(class_465<?> screen, ButtonPosition userPosition) {
        String className = ButtonPositionMap.getClassString(screen);
        ButtonPosition datapackPosition = datapackPositions.getOrDefault(className, null);
        if (userPosition.equals(datapackPosition)) {
            userPositions.remove(className);
        } else {
            userPositions.put(className, userPosition);
        }
        ButtonPositionMap.saveUserPositions();
    }

    public static ButtonPosition getPositionFor(class_465<?> screen) {
        String className = ButtonPositionMap.getClassString(screen);
        if (userPositions.containsKey(className)) {
            return userPositions.get(className);
        }
        if (datapackPositions.containsKey(className)) {
            return datapackPositions.get(className);
        }
        return datapackPositions.getOrDefault("DEFAULT", FALLBACK_DEFAULT);
    }
}

