/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.invbutton.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7654;
import org.apache.logging.log4j.Logger;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.gui.invbutton.ButtonPositionMap;
import red.jackf.chesttracker.impl.gui.invbutton.data.ButtonPositionDataFile;
import red.jackf.chesttracker.impl.gui.invbutton.position.ButtonPosition;

@Environment(value=EnvType.CLIENT)
public class InventoryButtonPositionLoader
implements SimpleResourceReloadListener<Map<String, ButtonPosition>> {
    private static final Logger LOGGER = ChestTracker.getLogger("Button Position Loader");
    private static final class_7654 LISTER = class_7654.method_45114((String)"chesttracker_button_positions");

    public CompletableFuture<Map<String, ButtonPosition>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, ButtonPosition> positions = new HashMap<String, ButtonPosition>();
            for (Map.Entry entry : LISTER.method_45113(manager).entrySet()) {
                class_2960 file = (class_2960)entry.getKey();
                class_2960 id = LISTER.method_45115(file);
                class_3298 resource = (class_3298)entry.getValue();
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        ButtonPositionDataFile result = (ButtonPositionDataFile)ButtonPositionDataFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonParseException::new);
                        for (String className : result.classNames()) {
                            positions.put(className, result.position());
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Couldn't read button positions {} from {} in data pack {}", (Object)id, (Object)file, (Object)resource.method_14480(), (Object)ex);
                }
            }
            return positions;
        }, executor);
    }

    public CompletableFuture<Void> apply(Map<String, ButtonPosition> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            ButtonPositionMap.loadDatapackPositions(data);
            return null;
        }, executor);
    }

    public class_2960 getFabricId() {
        return ChestTracker.id("button_position_loader");
    }
}

