/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.widget;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4264;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class HoldToConfirmButton
extends class_4264 {
    private final Consumer<HoldToConfirmButton> callback;
    private final long holdToActivateTime;
    private static final int PROGRESS_TICKS = 5;
    private final Set<Integer> held = new HashSet<Integer>(4);
    private float progress = 0.0f;
    private int progressTicks = 0;

    public HoldToConfirmButton(int x, int y, int width, int height, class_2561 component, long holdToActivateTime, Consumer<HoldToConfirmButton> callback) {
        super(x, y, width, height, component);
        this.holdToActivateTime = holdToActivateTime;
        this.callback = callback;
    }

    public void method_25306() {
        this.playDownSound(this.getPitch());
        this.callback.accept(this);
    }

    private float getPitch() {
        return 1.0f + 0.2f * (this.progress / (float)this.holdToActivateTime);
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(graphics, mouseX, mouseY, partialTick);
        if (this.progress > 0.0f) {
            graphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, (int)((float)this.method_46426() + this.progress / (float)this.holdToActivateTime * (float)(this.field_22758 - 2)), this.method_46427() + this.method_25364() - 1, 0x40FF0000);
        }
        if (!this.held.isEmpty()) {
            int newProgressTicks;
            this.progress = Math.min((float)this.holdToActivateTime, this.progress + partialTick);
            if (this.progress == (float)this.holdToActivateTime) {
                this.method_25306();
                this.progress = 0.0f;
                this.progressTicks = 0;
            }
            if ((newProgressTicks = (int)(this.progress * 5.0f / (float)this.holdToActivateTime)) > this.progressTicks) {
                this.playDownSound(this.getPitch());
            }
            this.progressTicks = newProgressTicks;
        } else {
            this.progress = Math.max(0.0f, this.progress - 2.0f * partialTick);
        }
        if (!this.field_22763) {
            this.held.clear();
        }
        if (this.held.contains(-1) && !this.method_25405(mouseX, mouseY)) {
            this.held.remove(-1);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && this.field_22763) {
            this.playDownSound(1.0f);
            this.held.add(-1);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.held.remove(-1);
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.field_22763 && !this.method_25405(mouseX, mouseY)) {
            this.held.remove(-1);
        }
        super.method_16014(mouseX, mouseY);
    }

    private static boolean isActivationKeybind(int keyCode) {
        return keyCode == 257 || keyCode == 32 || keyCode == 335;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_25370()) {
            return false;
        }
        if (HoldToConfirmButton.isActivationKeybind(keyCode)) {
            if (this.held.isEmpty()) {
                this.playDownSound(1.0f);
            }
            this.held.add(keyCode);
            return true;
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (HoldToConfirmButton.isActivationKeybind(keyCode)) {
            this.held.remove(keyCode);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
    }

    public void playDownSound(float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)pitch));
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }
}

