/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.util.Constants;
import red.jackf.chesttracker.impl.util.FileUtil;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;

@Environment(value=EnvType.CLIENT)
public record ConnectionSettings(Optional<String> memoryBankIdOverride) {
    private static final Path PATH = Constants.STORAGE_DIR.resolve("connection_settings.dat");
    private static Map<String, ConnectionSettings> settings = new HashMap<String, ConnectionSettings>();
    private static final Codec<ConnectionSettings> CONNECTION_SETTINGS_CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("memory_bank_id_override").forGetter(ConnectionSettings::memoryBankIdOverride)).apply((Applicative)i, ConnectionSettings::new));
    private static final Codec<Map<String, ConnectionSettings>> FILE_CODEC = JFLCodecs.mutableMap((Codec)Codec.unboundedMap((Codec)Codec.STRING, CONNECTION_SETTINGS_CODEC));

    public ConnectionSettings setOverride(Optional<String> memoryBankIdOverride) {
        return new ConnectionSettings(memoryBankIdOverride);
    }

    public static void load() {
        FileUtil.loadFromNbt(FILE_CODEC, PATH, null).ifPresent(connectionSettingsMap -> {
            settings = connectionSettingsMap;
        });
    }

    public static void save() {
        FileUtil.saveToNbt(settings, FILE_CODEC, PATH, null);
    }

    public static ConnectionSettings getOrCreate(String connectionId) {
        if (!settings.containsKey(connectionId)) {
            settings.put(connectionId, new ConnectionSettings(Optional.empty()));
            ConnectionSettings.save();
        }
        return settings.get(connectionId);
    }

    @Nullable
    public static ConnectionSettings get(String connectionId) {
        return settings.get(connectionId);
    }

    public static void put(String id, ConnectionSettings connectionSettings) {
        settings.put(id, connectionSettings);
        ConnectionSettings.save();
    }
}

