/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.storage.backend;

import java.util.Collection;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.Storage;
import red.jackf.chesttracker.impl.storage.backend.GameMemoryBackend;
import red.jackf.chesttracker.impl.storage.backend.JsonBackend;
import red.jackf.chesttracker.impl.storage.backend.NbtBackend;

@Environment(value=EnvType.CLIENT)
public interface Backend {
    @Nullable
    public MemoryBankImpl load(String var1, @Nullable class_7225.class_7874 var2);

    public void delete(String var1);

    public boolean save(MemoryBankImpl var1, @Nullable class_7225.class_7874 var2);

    default public class_2561 getDescriptionLabel(String memoryBankId) {
        return class_2561.method_43473();
    }

    public Collection<String> getAllIds();

    default public boolean exists(String id) {
        return this.getAllIds().contains(id);
    }

    public Optional<Metadata> loadMetadata(String var1);

    public boolean saveMetadata(String var1, Metadata var2);

    @Environment(value=EnvType.CLIENT)
    public static enum Type {
        JSON(new JsonBackend()),
        NBT(new NbtBackend()),
        MEMORY(new GameMemoryBackend());

        public final Backend instance;

        private Type(Backend instance) {
            this.instance = instance;
        }

        public void load() {
            MemoryBankAccessImpl.INSTANCE.unload();
            Storage.setBackend(this.instance);
        }
    }
}

