/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;

@Environment(value=EnvType.CLIENT)
public class ModCodecs {
    public static final Codec<class_1799> OPTIONAL_ITEMSTACK_UNCAPPED_SIZE = class_5699.method_57155((Codec)Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_47312.fieldOf("id").forGetter(class_1799::method_41409), (App)class_5699.field_33442.fieldOf("count").orElse((Object)1).forGetter(class_1799::method_7947), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(class_1799::method_57380)).apply((Applicative)instance, class_1799::new)))).xmap(opt -> opt.orElse(class_1799.field_8037), stack -> stack.method_7960() ? Optional.empty() : Optional.of(stack));
    public static final Codec<class_2338> BLOCK_POS_STRING = Codec.STRING.comapFlatMap(s -> {
        String[] split = s.split(",");
        if (split.length == 3) {
            try {
                int x = Integer.parseInt(split[0]);
                int y = Integer.parseInt(split[1]);
                int z = Integer.parseInt(split[2]);
                return DataResult.success((Object)new class_2338(x, y, z));
            }
            catch (NumberFormatException ex) {
                return DataResult.error(() -> "Invalid integer in key");
            }
        }
        return DataResult.error(() -> "Invalid number of coordinates: " + split.length);
    }, pos -> "%d,%d,%d".formatted(pos.method_10263(), pos.method_10264(), pos.method_10260()));
    public static final Codec<class_1799> ITEM_STACK_IGNORE_COUNT = Codec.xor((Codec)Codec.pair((Codec)class_7923.field_41178.method_39673().fieldOf("id").codec(), (Codec)class_9326.field_49589.fieldOf("patch").codec()), (Codec)class_7923.field_41178.method_39673()).xmap(ModCodecs::decodeEitherItemStack, stack -> !stack.method_57380().method_57848() ? Either.left((Object)Pair.of((Object)stack.method_7909(), (Object)stack.method_57380())) : Either.right((Object)stack.method_7909()));

    private static class_1799 decodeEitherItemStack(Either<Pair<class_1792, class_9326>, class_1792> either) {
        if (either.left().isPresent()) {
            Pair pair = (Pair)either.left().get();
            class_1799 stack = new class_1799((class_1935)pair.getFirst());
            stack.method_57366((class_9326)pair.getSecond());
            return stack;
        }
        return new class_1799((class_1935)either.right().orElseThrow());
    }

    public static <T> Codec<T> singular(Codec<T> typeCodec, T value) {
        return JFLCodecs.oneOf(typeCodec, Collections.singleton(value));
    }

    public static <T> Codec<Set<T>> set(Codec<T> base) {
        return base.listOf().xmap(Set::copyOf, List::copyOf);
    }

    public static <T> Codec<T> predicate(final Predicate<Dynamic<?>> decodingPredicate, final Codec<T> base) {
        return new Codec<T>(){

            public <A> DataResult<Pair<T, A>> decode(DynamicOps<A> ops, A input) {
                Dynamic dynamic = new Dynamic(ops, input);
                if (decodingPredicate.test(dynamic)) {
                    return base.decode(dynamic);
                }
                return DataResult.error(() -> "Did not match predicate: " + String.valueOf(input));
            }

            public <A> DataResult<A> encode(T input, DynamicOps<A> ops, A prefix) {
                return base.encode(input, ops, prefix);
            }

            public String toString() {
                return "DecoderPredicateCodec[" + String.valueOf(base) + "]";
            }
        };
    }
}

