/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.client.config;

import com.google.gson.GsonBuilder;
import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.client.config.CarouselView;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.config.GsonConfigInstance;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_2561;

public class SkinShuffleConfig {
    private static final Path CONFIG_FILE_PATH = SkinShuffle.DATA_DIR.resolve("config.json");
    private static final GsonConfigInstance<SkinShuffleConfig> GSON = GsonConfigInstance.createBuilder(SkinShuffleConfig.class).overrideGsonBuilder(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create()).setPath(CONFIG_FILE_PATH).build();
    @SerialEntry
    public boolean disableReconnectToast = false;
    @SerialEntry
    public boolean disableAPIUpload = false;
    @SerialEntry
    public boolean displayInPauseMenu = true;
    @SerialEntry
    public boolean displayInTitleScreen = true;
    @SerialEntry
    public float carouselScrollSensitivity = 1.0f;
    @SerialEntry
    public boolean invertCarouselScroll = false;
    @SerialEntry
    public SkinRenderStyle widgetSkinRenderStyle = SkinRenderStyle.CURSOR;
    @SerialEntry
    public SkinRenderStyle carouselSkinRenderStyle = SkinRenderStyle.ROTATION;
    @SerialEntry
    public SkinRenderStyle presetEditScreenRenderStyle = SkinRenderStyle.ROTATION;
    @SerialEntry
    public float rotationMultiplier = 1.0f;
    @SerialEntry
    public boolean showCapeInPreview = false;
    @SerialEntry
    public CarouselView carouselView = CarouselView.LARGE;

    public static SkinShuffleConfig get() {
        return (SkinShuffleConfig)GSON.getConfig();
    }

    public static void load() {
        GSON.load();
        SkinShuffleConfig.get().postLoad();
    }

    public static void save() {
        GSON.save();
    }

    public void postLoad() {
        SkinShuffleConfig.save();
    }

    public static YetAnotherConfigLib getInstance() {
        return YetAnotherConfigLib.create(GSON, (defaults, config, builder) -> {
            Option carouselRenderStyle = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.rendering.carousel_rendering_style.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.rendering.carousel_rendering_style.description"), class_2561.method_43471((String)"skinshuffle.config.rendering.rendering_style")}).build()).binding((Object)defaults.carouselSkinRenderStyle, () -> config.carouselSkinRenderStyle, val -> {
                config.carouselSkinRenderStyle = val;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(SkinRenderStyle.class).valueFormatter(skinRenderStyle -> class_2561.method_43471((String)("skinshuffle.config.rendering." + skinRenderStyle.name().toLowerCase())))).build();
            Option presetEditScreenRenderStyle = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.rendering.preset_edit_screen_rendering_style.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.rendering.preset_edit_screen_rendering_style.description"), class_2561.method_43471((String)"skinshuffle.config.rendering.rendering_style")}).build()).binding((Object)defaults.presetEditScreenRenderStyle, () -> config.presetEditScreenRenderStyle, val -> {
                config.presetEditScreenRenderStyle = val;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(SkinRenderStyle.class).valueFormatter(skinRenderStyle -> class_2561.method_43471((String)("skinshuffle.config.rendering." + skinRenderStyle.name().toLowerCase())))).build();
            Option widgetRenderStyle = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.rendering.widget_rendering_style.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.rendering.widget_rendering_style.description"), class_2561.method_43471((String)"skinshuffle.config.rendering.rendering_style")}).build()).binding((Object)defaults.widgetSkinRenderStyle, () -> config.widgetSkinRenderStyle, val -> {
                config.widgetSkinRenderStyle = val;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(SkinRenderStyle.class).valueFormatter(skinRenderStyle -> class_2561.method_43471((String)("skinshuffle.config.rendering." + skinRenderStyle.name().toLowerCase())))).build();
            Option rotationMultiplier = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.rendering.rotation_speed.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.rendering.rotation_speed.description")}).build()).binding((Object)Float.valueOf(defaults.rotationMultiplier), () -> Float.valueOf(config.rotationMultiplier), val -> {
                config.rotationMultiplier = val.floatValue();
            }).controller(floatOption -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)floatOption).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(5.0f))).step((Number)Float.valueOf(0.5f))).build();
            Option showCapeInPreview = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.rendering.show_cape_in_preview.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.rendering.show_cape_in_preview.description")}).build()).binding((Object)defaults.showCapeInPreview, () -> config.showCapeInPreview, val -> {
                config.showCapeInPreview = val;
            }).controller(TickBoxControllerBuilder::create).build();
            Option disableApi = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.general.disable_api.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.general.disable_api.description")}).build()).binding((Object)defaults.disableAPIUpload, () -> config.disableAPIUpload, val -> {
                config.disableAPIUpload = val;
            }).controller(TickBoxControllerBuilder::create).build();
            Option displayWidgetPause = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.general.display_pause_screen.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.general.display_pause_screen.description")}).build()).binding((Object)defaults.displayInPauseMenu, () -> config.displayInPauseMenu, val -> {
                config.displayInPauseMenu = val;
            }).controller(TickBoxControllerBuilder::create).build();
            Option displayWidgetTitleScreen = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.general.display_title_screen.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.general.display_title_screen.description")}).build()).binding((Object)defaults.displayInTitleScreen, () -> config.displayInTitleScreen, val -> {
                config.displayInTitleScreen = val;
            }).controller(TickBoxControllerBuilder::create).build();
            Option carouselScrollSensitivity = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.general.carousel_scroll_sensitivity.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.general.carousel_scroll_sensitivity.description")}).build()).binding((Object)Float.valueOf(defaults.carouselScrollSensitivity), () -> Float.valueOf(config.carouselScrollSensitivity), val -> {
                config.carouselScrollSensitivity = val.floatValue();
            }).controller(floatOption -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)floatOption).range((Number)Float.valueOf(0.1f), (Number)Float.valueOf(5.0f))).step((Number)Float.valueOf(0.1f))).build();
            Option invertCarouselScroll = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.general.invert_carousel_scroll.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.general.invert_carousel_scroll.description")}).build()).binding((Object)defaults.invertCarouselScroll, () -> config.invertCarouselScroll, val -> {
                config.invertCarouselScroll = val;
            }).controller(TickBoxControllerBuilder::create).build();
            Option disableRnnoctToast = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.popups.reconnect.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.popups.reconnect.description")}).build()).binding((Object)defaults.disableReconnectToast, () -> config.disableReconnectToast, val -> {
                config.disableReconnectToast = val;
            }).controller(TickBoxControllerBuilder::create).build();
            return builder.title((class_2561)class_2561.method_43471((String)"skinshuffle.config.title")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.general.title")).tooltip(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.general.description")}).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.general.behaviour.title")).options(List.of(disableApi, carouselScrollSensitivity, invertCarouselScroll)).build()).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.general.display.title")).options(List.of(displayWidgetPause, displayWidgetTitleScreen)).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.rendering.title")).tooltip(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.rendering.description")}).options(List.of(carouselRenderStyle, presetEditScreenRenderStyle, widgetRenderStyle, rotationMultiplier, showCapeInPreview)).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"skinshuffle.config.popups.title")).tooltip(new class_2561[]{class_2561.method_43471((String)"skinshuffle.config.popups.description")}).options(List.of(disableRnnoctToast)).build());
        });
    }

    public static enum SkinRenderStyle {
        ROTATION,
        CURSOR;

    }
}

