/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.client.skin;

import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.api.SkinAPIs;
import com.mineblock11.skinshuffle.api.SkinQueryResult;
import com.mineblock11.skinshuffle.client.skin.ConfigSkin;
import com.mineblock11.skinshuffle.client.skin.UUIDSkin;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class UsernameSkin
extends UUIDSkin {
    public static final class_2960 SERIALIZATION_ID = SkinShuffle.id("username");
    public static final MapCodec<UsernameSkin> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("username").forGetter(skin -> skin.username), (App)Codec.STRING.optionalFieldOf("model").forGetter(skin -> Optional.ofNullable(skin.model))).apply((Applicative)instance, UsernameSkin::new));
    private final String username;

    public UsernameSkin(String username, @Nullable String model) {
        super(model);
        this.username = username;
    }

    private UsernameSkin(String username, Optional<String> model) {
        this(username, (String)model.orElse(null));
    }

    @Override
    public ConfigSkin saveToConfig() {
        Optional<UUID> uuid = SkinAPIs.getUUIDFromUsername(this.username);
        if (uuid.isEmpty()) {
            throw new RuntimeException("UUID is not a valid player UUID.");
        }
        SkinQueryResult queryResult = SkinAPIs.getPlayerSkinTexture(uuid.get().toString());
        this.url = queryResult.skinURL();
        return super.saveToConfig();
    }

    @Override
    protected Object getTextureUniqueness() {
        return this.username;
    }

    @Override
    @Nullable
    protected class_1044 loadTexture(Runnable completionCallback) {
        Optional<UUID> uuid = SkinAPIs.getUUIDFromUsername(this.username);
        if (!uuid.isPresent()) {
            return null;
        }
        this.uuid = uuid.get();
        return super.loadTexture(completionCallback);
    }

    @Override
    public class_2960 getSerializationId() {
        return SERIALIZATION_ID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UsernameSkin that = (UsernameSkin)o;
        return Objects.equals(this.username, that.username) && super.equals(o);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        return result;
    }
}

