/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.skinshuffle.networking;

import com.mineblock11.skinshuffle.SkinShuffle;
import com.mineblock11.skinshuffle.networking.HandshakePayload;
import com.mineblock11.skinshuffle.networking.RefreshPlayerListEntryPayload;
import com.mineblock11.skinshuffle.networking.SkinRefreshPayload;
import com.mineblock11.skinshuffle.util.SkinShufflePlayer;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ServerSkinHandling {
    private static void handleSkinRefresh(MinecraftServer server, class_3222 player, Property skinData) {
        SkinShuffle.LOGGER.info("Recieved skin refresh packet from: " + player.method_5477().getString());
        server.execute(() -> {
            PropertyMap properties = player.method_7334().getProperties();
            try {
                properties.removeAll((Object)"textures");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                properties.put((Object)"textures", (Object)skinData);
            }
            catch (Error e) {
                SkinShuffle.LOGGER.error("Failed to refresh GameProfile for " + String.valueOf(player.method_5477()) + "\n" + e.getMessage());
            }
            SkinShufflePlayer skinShufflePlayer = (SkinShufflePlayer)player;
            skinShufflePlayer.skinShuffle$refreshSkin();
        });
    }

    public static boolean attemptPlayerListEntryRefresh(class_3222 player, int entityID) {
        if (ServerPlayNetworking.canSend((class_3222)player, RefreshPlayerListEntryPayload.PACKET_ID)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new RefreshPlayerListEntryPayload(entityID));
            return true;
        }
        return false;
    }

    public static void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (ServerPlayNetworking.canSend((class_3222)handler.method_32311(), HandshakePayload.PACKET_ID)) {
                ServerPlayNetworking.send((class_3222)handler.method_32311(), (class_8710)new HandshakePayload());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(SkinRefreshPayload.PACKET_ID, (payload, context) -> {
            try {
                ServerSkinHandling.handleSkinRefresh(context.server(), context.player(), payload.textureProperty());
            }
            catch (Exception e) {
                SkinShuffle.LOGGER.error("Failed to handle skin refresh packet from " + context.player().method_5477().getString() + "\n" + e.getMessage());
            }
        });
    }
}

