/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.impl.client.gui.TooltipBuilderImpl;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2477;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_8030;
import net.minecraft.class_9110;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WidgetTooltipHolderImpl
extends class_9110 {
    private final class_339 abstractWidget;
    private List<? extends class_5348> tooltipLines;
    @Nullable
    private final BiFunction<class_8000, class_339, class_8000> tooltipPositionerFactory;
    private final Function<List<? extends class_5348>, List<class_5481>> tooltipLineProcessor;
    @Nullable
    private final Supplier<List<? extends class_5348>> tooltipLinesSupplier;

    public WidgetTooltipHolderImpl(class_339 abstractWidget, TooltipBuilderImpl builder) {
        Preconditions.checkState((!builder.tooltipLines.isEmpty() || builder.tooltipLinesSupplier != null ? 1 : 0) != 0, (Object)"lines is empty");
        this.abstractWidget = abstractWidget;
        this.tooltipLines = builder.tooltipLinesSupplier != null ? Collections.emptyList() : ImmutableList.copyOf(builder.tooltipLines);
        this.tooltipLineProcessor = builder.tooltipLineProcessor;
        this.tooltipPositionerFactory = builder.tooltipPositionerFactory;
        this.tooltipLinesSupplier = builder.tooltipLinesSupplier;
        super.method_56141(builder.tooltipDelay);
        super.method_56138(new class_7919(class_5244.field_39003, null){

            public List<class_5481> method_47405(class_310 minecraft) {
                class_2477 language = class_2477.method_10517();
                if (this.field_41103 == null || language != this.field_51822) {
                    this.field_41103 = this.processTooltipLines(WidgetTooltipHolderImpl.this.tooltipLines);
                    this.field_51822 = language;
                }
                return this.field_41103;
            }

            private List<class_5481> processTooltipLines(List<? extends class_5348> tooltipLines) {
                Preconditions.checkState((!tooltipLines.isEmpty() ? 1 : 0) != 0, (Object)"lines is empty");
                return WidgetTooltipHolderImpl.this.tooltipLineProcessor.apply(tooltipLines);
            }
        });
    }

    public void method_56141(Duration delay) {
    }

    public void method_56138(@Nullable class_7919 tooltip) {
    }

    @NotNull
    public class_7919 method_56137() {
        class_7919 tooltip = super.method_56137();
        Objects.requireNonNull(tooltip, "tooltip is null");
        return tooltip;
    }

    public void method_56142(boolean hovering, boolean focused, class_8030 screenRectangle) {
        this.refreshLines(this.getLinesForNextRenderPass());
        Preconditions.checkState((!this.tooltipLines.isEmpty() ? 1 : 0) != 0, (Object)"lines is empty");
        super.method_56142(hovering, focused, screenRectangle);
    }

    private List<? extends class_5348> getLinesForNextRenderPass() {
        if (this.tooltipLinesSupplier != null) {
            return this.tooltipLinesSupplier.get();
        }
        return Collections.emptyList();
    }

    private void refreshLines(List<? extends class_5348> lines) {
        if (!lines.isEmpty() && !Objects.equals(lines, this.tooltipLines)) {
            this.tooltipLines = lines;
            this.method_56137().field_41103 = null;
        }
    }

    protected class_8000 method_56140(class_8030 screenRectangle, boolean hovering, boolean focused) {
        class_8000 tooltipPositioner = super.method_56140(screenRectangle, hovering, focused);
        if (this.tooltipPositionerFactory != null) {
            return this.tooltipPositionerFactory.apply(tooltipPositioner, this.abstractWidget);
        }
        return tooltipPositioner;
    }
}

